  import java.awt.*;
  import java.awt.event.*;
  import javax.swing.*;
  
  public class BarChart extends JPanel
  implements ActionListener
  {
     static int barHeight = 40;
     int barCount;
     
     public BarChart()
     {
        super();
        setPreferredSize (new Dimension (200, 200));
         setLayout (null);
  
        addBackground(); // powinna by umieszczona na kocu!
  
        addBar ("March", 100, Color.red);
        addBar ("April", 120, Color.yellow);
        addBar ("May",   160, Color.green);
        addBar ("June",  130, Color.white);
     }
     
     private void addBackground()
     {
         JButton background = new JButton();
         background.setActionCommand ("background");
         background.setBounds (0, 0, 200, 200);
         background.setOpaque (false);
         background.addActionListener (this);
         add (background);
     }
     
     private void addBar(String lbl, int w, Color c)
     {
         JButton bar = new JButton (lbl);
         int y = barCount * (barHeight + 10);
         bar.setBounds (10, y, w, barHeight);
         bar.setBackground (c);
         bar.addActionListener (this);
         add (bar);
         barCount++;
     }
  
     public void actionPerformed (ActionEvent e)
     {
        System.out.println
           ("Button = " + e.getActionCommand());
     }
           
     public static void main (String[] args)
     {
        BarChart panel = new BarChart();
        JFrame frame = new JFrame ("BarChart");
        frame.getContentPane().setLayout
           (new BorderLayout());
        frame.getContentPane().add
           (panel, BorderLayout.CENTER);
        frame.pack();
        frame.show();
     }
  }
