 import java.awt.*;
 import java.awt.event.*;
 import java.net.*;
 import javax.swing.*;

 public class LiveImage implements ActionListener
 {
    JButton button;
    URL url;
    Timer timer;
    final int INTERVAL = 30 * 1000; // 30 sekund

    public LiveImage (String title, String path)
       throws MalformedURLException
    {
       button = new JButton();
       button.addActionListener (this);

       url = new URL (path);
       update();
       JDialog dialog =
          new JDialog ((Frame)null, title, false);
       dialog.getContentPane().add (button);
       dialog.pack();
       dialog.show();

       timer = new Timer (INTERVAL, this);
       timer.start(); // wywouje metod actionPerformed
    }

    public void update()
    {
       System.out.println ("Updating " + url);
       button.setIcon (new ImageIcon (url));
    }

    public void actionPerformed (ActionEvent e)
    {
       update();
    }

    public static void main (String[] args)
    {
       String title = "Times Square Live";
       String path = "http://images.earthcam.com/" +
          "ec_metros/newyork/newyork/lindys.jpg";
       try
       {
          new LiveImage (title, path);
       }
       catch (MalformedURLException e)
       {
          System.err.println (e.getMessage());
       }
    }
 }
