/* ObjectReceiver2.java */
 import java.io.*;
 import java.net.*;
 
 public class ObjectReceiver2
 {
     ServerSocket ss;
     
     public ObjectReceiver2(int port) throws IOException
     {
         ss = new ServerSocket(port);    
     }
     
     public void listen() throws IOException, ClassNotFoundException
     {
         Socket s = ss.accept();
         ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
         ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
         Object o = ois.readObject();    
         System.out.println("Object: " + o);
     }
     
     public static void main(String args[])
     {
         if (args.length < 1)
         {
             System.out.println("USAGE: java ObjectReceiver2 port");
             System.exit(1);
         }
                 
         try
         {
             ObjectReceiver2 or2 = 
                   new ObjectReceiver2(Integer.parseInt(args[0]));
             or2.listen();
         } catch (Exception e)
           {
             e.printStackTrace();  
           }
     }
 }
