/* ObjectFile.java */
 package jwiley.effective;
 
 import java.io.*;
 import java.util.*;
 
 public class ObjectFile
 {
    RandomAccessFile dataFile;
    String sFileName;
 
    public ObjectFile(String sName) throws IOException
    {
       sFileName = sName;
       dataFile = new RandomAccessFile(sName, "rw");
    }
 
    // zwraca pozycj pliku, na ktrej zapisano obiekt
    public synchronized long writeObject(Serializable obj) throws IOException
    {
       ByteArrayOutputStream baos = new ByteArrayOutputStream();
       ObjectOutputStream oos = new ObjectOutputStream(baos);
       oos.writeObject(obj);
       oos.flush();
 
       int datalen = baos.size();
 
       // docza rekord
       long pos = dataFile.length();
       dataFile.seek(pos);
 
       // zapisuje rozmiar danych
       dataFile.writeInt(datalen);
       dataFile.write(baos.toByteArray());
 
       baos = null; oos = null;
 
       return pos;
    }
 
 
    // pobiera biecy rozmiar obiektu
    public synchronized int getObjectLength(long lPos) throws IOException
    {
       dataFile.seek(lPos);
       return dataFile.readInt();
    }
 
    public synchronized Object readObject(long lPos) 
                 throws IOException,ClassNotFoundException
    {
       dataFile.seek(lPos);
       int datalen = dataFile.readInt();
       if (datalen > dataFile.length())
          throw new IOException("Data file is corrupted. datalen: " 
                                 + datalen);
       byte [] data = new byte[datalen];
       dataFile.readFully(data);
 
       ByteArrayInputStream bais = new ByteArrayInputStream(data);
       ObjectInputStream ois = new ObjectInputStream(bais);
       Object o = ois.readObject();
 
       bais = null;    item 20
       ois = null;
       data = null;
 
       return o;
    }
 
    public long length() throws IOException
    {
       return dataFile.length();
    }
 
    public void close() throws IOException
    {
       dataFile.close();
    }
    // Metody pominite ze wzgldu na brak miejsca
 } // koniec klasy ObjectFile
