/* MethodDispatch3.java */
 
 import java.lang.reflect.*;
 
 class Foo1
 {
     void doIt(int i)
     {
         System.out.println("Called Foo1.doIt() with arg: " + i);    
     }
 }
 
 class Foo2
 {
     void doIt(int i)
     {
         System.out.println("Called Foo2.doIt() with arg: " + i);    
     }    
     
     void doItAgain(int i, int j)
     {
         System.out.println("Called Foo2.doItAgain(" + i + "," 
                                                     + j + ")");
     }
 }
 
 public class MethodDispatch3
 {
     public static void dispatch(Object o, Method m, 
                            Object [] args) throws InvocationTargetException,
                                                   IllegalAccessException
     {
         m.invoke(o, args);
     }
     
     public static void main(String args[])
     {
         try
         {
             Foo1 f1; 
             Foo2 f2;
             Object [] objs = { f1 = new Foo1(), f2 = new Foo2() };
             Class [] carg = { int.class };
             Class [] carg2 = { int.class, int.class };
             Method [] meths = { f1.getClass().getDeclaredMethod("doIt",carg),
                                 f2.getClass().getDeclaredMethod("doItAgain",
                                 carg2) };
             Object [][] margs = { { new Integer(10) }, { new Integer(20),
                                                          new Integer(30)}};
             for (int i=0; i < objs.length; i++)
                 dispatch(objs[i], meths[i], margs[i]);
         } catch (Throwable t)
           {
             t.printStackTrace();  
           }
     }
 }
