import java.util.*;
 
 class Mammal
 {
     public Hashtable attributes = new Hashtable();
 
     public Mammal (String name)
     {
         attributes.put("Name", name);
     }
 
     public Object clone ()
     {
         Mammal newMammal = new Mammal((String)attributes.get("Name"));
         newMammal.attributes = (Hashtable)attributes.clone();
         return (newMammal);
     }
 
     public String toString ()
     {
         return ("Name: " + attributes.get("Name"));
     }
 }
 
 class Dog extends Mammal
 {
     Vector tricks;
 
     public Dog (String name, String breed, Vector tricks)
     {
         super (name);
         this.attributes.put("Breed", breed);
         this.tricks = tricks;
     }
 
     public Object clone ()
     {
         Dog newDog = (Dog) super.clone();
         newDog.tricks = (Vector) tricks.clone();
         return (newDog);
     }
 
     public String toString ()
     {
         String s = super.toString() + "\nBreed: " +
                      this.attributes.get("Breed") +
                      "\nTricks:";
         for (int i = 0; i < tricks.size(); i++)
             s = s + "\n" + tricks.elementAt(i);
         return (s);
     }
 }
 
 public class CloneDog
 {
     public static void main (String args[])
     {
         Vector tricks = new Vector();
         tricks.addElement("Roll over");
         tricks.addElement("Play dead");
 
         Dog rover = new Dog("Rover", "Beagle", tricks);
         Dog roverClone = (Dog) rover.clone();
 
         System.out.println(rover.toString());
         System.out.println("\nClone: \n" + roverClone.toString());
     }
 }
