import java.applet.*;
 import java.awt.*;
 import java.io.*;
 import java.net.*;

 import javax.swing.*;
 import javax.swing.event.*;

 public class SoundDialog extends ListDialog
 implements FilenameFilter, ListSelectionListener
 {
    String selection;

    public SoundDialog (String title, LDListener ldl, String path)
    {
       super (title, null, ldl);
       String[] items = getItems (path);
       setModel (items);
    }

    public void setModel (String[] items)
    {
       if (items != null)
       {
          super.setModel (items);
          model.addListSelectionListener (this);
          model.setSelectionMode
            (ListSelectionModel.SINGLE_SELECTION);
       }
    }

    public String[] getItems (String path)
    {
       File file = new File (path);
       File soundFiles[] = file.listFiles (this);
       String[] items = new String [soundFiles.length];
       for (int i = 0; i < soundFiles.length; i++)
          items[i] = soundFiles[i].getName();
       return (items);
    }

    // implementuje FilenameFilter
    public boolean accept (File dir, String name)
    {
       return (name.endsWith (".aiff") ||
               name.endsWith (".au")   ||
               name.endsWith (".midi") ||
               name.endsWith (".rmf")  ||
               name.endsWith (".wav"));
    }

    // implementuje ListSelectionListener
    public void valueChanged (ListSelectionEvent e)
    {
       super.valueChanged (e);
       JList items = (JList) e.getSource();
       String fileName = items.getSelectedValue().toString();
       if (!fileName.equals (selection))
       {
          selection = fileName;
          play (selection);
       }
    }

    private void play (String fileName)
    {
       try
       {
          File file = new File (fileName);
          URL url = new URL ("file://" + file.getAbsolutePath());
          AudioClip audioClip = Applet.newAudioClip (url);
          if (audioClip != null)
             audioClip.play();
       }
       catch (MalformedURLException e)
       {
          System.err.println (e + ": " + e.getMessage());
       }
    }

    public static void main (String[] args) // test
    {
       LDListener listener =
          new LDListener()
          {
             public void listDialogSelection (LDEvent e)
             {
                Object[] selected = e.getSelection();
                if (selected != null) // null gdy uytkownik anuluje
                   for (int i = 0; i < selected.length; i++)
                      System.out.println (selected[i].toString());
                System.exit (0);
             }
          };
       SoundDialog dialog =
          new SoundDialog ("SoundDialog", listener, ".");
       dialog.show();
    }
 }
