import java.awt.*;
 import java.awt.event.*;
 import java.io.*;
 import java.util.*;

 import javax.swing.*;
 import javax.swing.event.*;

 public class ListDialog extends JDialog
 implements ActionListener, ListSelectionListener
 {
    JList model;
    JButton selectButton;
    LDListener listener;
    Object[] selections;

    public ListDialog (String title,
                       String[] items,
                       LDListener listener)
    {
       super ((Frame)null, title);

       JPanel buttonPane = new JPanel ();
       selectButton = new JButton ("SELECT");
       selectButton.addActionListener (this);
       selectButton.setEnabled (false); // jeszcze nic nie wybrano
       buttonPane.add (selectButton);

       JButton cancelButton = new JButton ("CANCEL");
       cancelButton.addActionListener (this);
       buttonPane.add (cancelButton);

       this.getContentPane().add (buttonPane, BorderLayout.SOUTH);

       this.listener = listener;
       setModel (items);
    }

    void setModel (String[] items)
    {
       if (this.model != null)
          this.model.removeListSelectionListener (this);
       this.model = new JList (items);
       model.addListSelectionListener (this);

       JScrollPane scroll = new JScrollPane (model);
       this.getContentPane().add (scroll, BorderLayout.CENTER);
       this.pack();
    }

    /** Implementuje ListSelectionListener. ledzi wybr uytkownika. */

    public void valueChanged (ListSelectionEvent e)
    {
       selections = model.getSelectedValues();
       if (selections.length > 0)
          selectButton.setEnabled (true);
    }

    /** Implementuje ActionListener.  Wywoywana, gdy uytkownik wybiera przycisk
     * SELECT lub CANCEL. Generuje LDEvent. */

    public void actionPerformed (ActionEvent e)
    {
       this.setVisible (false);
       String buttonLabel = e.getActionCommand();
       if (buttonLabel.equals ("CANCEL"))
          selections = null;
       if (listener != null)
       {
          LDEvent lde = new LDEvent (this, selections);
          listener.listDialogSelection (lde);
       }
    }

    public static void main (String[] args) // kod testujcy
    {
       String[] items = (new String[]
          {"Forest", "Island", "Mountain", "Plains", "Swamp"});
       LDListener listener =
          new LDListener()
          {
             public void listDialogSelection (LDEvent e)
             {
                Object[] selected = e.getSelection();
                if (selected != null) // null gdy uytkownik anuluje
                   for (int i = 0; i < selected.length; i++)
                      System.out.println (selected[i].toString());
                System.exit (0);
             }
          };

       ListDialog dialog =
          new ListDialog ("ListDialog", items, listener);
       dialog.show();
    }
 }
