package com.oreilly.tiger.ch06;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.annotation.Annotation;

public class ReflectionTester {

  public ReflectionTester() {
  }

  public void testAnnotationPresent(PrintStream out) throws IOException {
    Class c = Super.class;
    boolean inProgress = c.isAnnotationPresent(InProgress.class);
    if (inProgress) {
      out.println("Klasa Super posiada adnotacj InProgress");
    } else {
      out.println("Klasa Super nie posiada adnotacji InProgress");
    }
  }

  public void testInheritedAnnotation(PrintStream out) throws IOException {
    Class c = Sub.class;
    boolean inProgress = c.isAnnotationPresent(InProgress.class);
    if (inProgress) {
      out.println("Klasa Sub posiada adnotacj InProgress");
    } else {
      out.println("Klasa Sub nie posiada adnotacji InProgress");
    }
  }

  public void testGetAnnotation(PrintStream out) 
    throws IOException, NoSuchMethodException {

    Class c = AnnotationTester.class;
    AnnotatedElement element = c.getMethod("calculateInterest", 
                                  float.class, float.class);

    GroupTODO groupTodo = element.getAnnotation(GroupTODO.class);
    String assignedTo = groupTodo.assignedTo();

    out.println("Adnotacja TODO klasy AnnotationTester zostaa przypisana osobie: '" + 
        assignedTo + "'");
  }

  public void printAnnotations(AnnotatedElement e, PrintStream out)
    throws IOException {

    out.printf("Adnotacje elementu '%s'%n%n", e.toString());

    Annotation[] annotations = e.getAnnotations();
    for (Annotation a : annotations) {
      out.printf("    * Odnaleziono adnotacj '%s'%n", 
        a.annotationType().getName());
    }
  }

  public static void main(String[] args) {
    try {
      ReflectionTester tester = new ReflectionTester();

      tester.testAnnotationPresent(System.out);
      tester.testInheritedAnnotation(System.out);

      tester.testGetAnnotation(System.out);

      Class c = AnnotationTester.class;
      AnnotatedElement element = c.getMethod("calculateInterest", 
                                    float.class, float.class);      
      tester.printAnnotations(element, System.out);
    } catch (Exception e) {
      e.printStackTrace();
    } 
  }
}