package com.oreilly.tiger.ch03;

public enum GuitarFeatures implements Features {

  ROSEWOOD(0),        // boki/spd
  MAHOGANY(0),        // boki/spd
  ZIRICOTE(300),      // boki/spd

  SPRUCE(0),          // wierzch
  CEDAR(0),           // wierzch

  AB_ROSETTE(75),     // rozeta abalone
  AB_TOP_BORDER(400), // obwdka abalone

  IL_DIAMONDS(150),   // inkrustacje rombowe
  IL_DOTS(0);         // inkrustacje okrge

  /** "Cena" cechy */
  private float upcharge;

  GuitarFeatures(float upcharge) {
    this.upcharge = upcharge;
  }

  public float getUpcharge() {
    return upcharge;
  }

  public String getDescription() {
    switch(this) {
      case ROSEWOOD:      return "Spd i boki z palisandru";
      case MAHOGANY:      return "Spd i boki z mahoniu";
      case ZIRICOTE:      return "Spd i boki z drewna ziricote";
      case SPRUCE:        return "Wierzch ze wierku Sitka";
      case CEDAR:         return "Wierzch z cedru Wester Red ";
      case AB_ROSETTE:    return "Rozeta abalone";
      case AB_TOP_BORDER: return "Obwdka abalone";
      case IL_DIAMONDS:   
        return "Rombowe inkrustacje podstrunnicy";
      case IL_DOTS:
        return "Okrge inkrustacje podstrunnicy";
      default: return "Cecha nieznana";
    }
  }
}