package com.oreilly.tiger.ch10;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

import static java.util.concurrent.TimeUnit.*;

public class ScheduleTester {

  public static void main(String[] args) {
    // Pobiera implementacj ScheduledExecutorService
    ScheduledExecutorService scheduler =
      Executors.newSingleThreadScheduledExecutor();

    // Pobiera uchwyt, starting now, with a 10 second delay
    final ScheduledFuture<?> timeHandle =
      scheduler.scheduleAtFixedRate(new TimePrinter(System.out), 0, 10, SECONDS);    

    // Planuje zdarzenie i wykonuje przez godzin (60 * 60 sekund)
    scheduler.schedule(new Runnable() {
      public void run() {
        timeHandle.cancel(false);
      }
    }, 60*60, SECONDS);


    /**
     * Aby zaobserwowa wynik dziaania na niektrych platformach
     * konieczne jest wstawienie poniszej ptli
    while (true) { }
     */
  }
}

class TimePrinter implements Runnable {

  private PrintStream out;

  public TimePrinter(PrintStream out) {
    this.out = out;
  }

  public void run() {
    out.printf("Aktualny czas: %tr%n", new Date());
  }
}