package com.oreilly.tiger.ch07;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ForInGenericsDemo {

  public static void main(String[] args) {

    // Kolekcje, ktre bdziemy przeglda
    List<String> wordlist = new ArrayList<String>();
    Set<String> wordset = new HashSet<String>();

    // Podstawowa ptla przegldania tablicy.
    // Ciao ptli jest wykonywane raz dla kadego elementu tablicy args[].
    // W kadym przebiegu ptli jeden element jest przypisywany zmiennej word.
    System.out.println("Wstawianie argumentw do kolekcji...");
    for(String word : args) {
      System.out.print(word + " ");
      wordlist.add(word);
      wordset.add(word);
    }

    System.out.println();

    // Przegldanie elementw listy.
    // Poniewa listy s uporzdkowane, to sowa zostan wywietlone
    // w kolejnoci w jakiej zostay wprowadzone
    System.out.println("Wywietlanie sw z listy " +
      "(uporzdkowanych, z duplikatami)...");
    for(String word : wordlist) {
      System.out.print(word + " ");
    }

    System.out.println();

    // To samo wykonujemy dla zbioru. Ptla wyglda tak samo,
    // ale zastosowanie zbioru powoduje utrat uporzdkowania oraz duplikatw.
    System.out.println("Wywietlanie sw ze zbioru " +
      "(nieuporzdkowanych, bez duplikatw)...");
    for(String word : wordset) {
      System.out.print(word + " ");
    }
  }
}
