package com.oreilly.tiger.ch01;

import java.util.Arrays;
import java.util.List;

public class ArraysTester {

  private int[] ar;

  public ArraysTester(int numValues) {
    ar = new int[numValues];

    for (int i=0; i < ar.length; i++) {
      ar[i] = (1000 - (300 + i));
    }
  }

  public int[] get() {
    return ar;
  }

  public static void main(String[] args) {
    ArraysTester tester = new ArraysTester(50);
    int[] myArray = tester.get();

    // Porwnuje dwie tablice
    int[] myOtherArray = tester.get().clone();
    if (Arrays.equals(myArray, myOtherArray)) {
      System.out.println("Tablice s takie same!");
    } else {
      System.out.println("Tablice s rne!");
    }

    // Wypenia tablic
    Arrays.fill(myOtherArray, 2, 10, new Double(Math.PI).intValue());
    myArray[30] = 98;

    // Wywietla zawarto tablicy
    System.out.println("Zawarto nieposortowanej tablicy...");
    System.out.println(Arrays.toString(myArray));
    System.out.println();

    // Sortuje tablic
    Arrays.sort(myArray);
    
    // Wywietla zawarto posortowanej tablicy
    System.out.println("Zawarto posortowanej tablicy...");
    System.out.println(Arrays.toString(myArray));
    System.out.println();

    // Znajduje indeks elementu w tablicy
    int index = Arrays.binarySearch(myArray, 98);
    System.out.println("Warto 98 posiada w tablicy indeks rwny " + index);

    String[][] ticTacToe = { {"X", "O", "O"},
                             {"O", "X", "X"}, 
                             {"X", "O", "X"}};
    System.out.println(Arrays.deepToString(ticTacToe));

    String[][] ticTacToe2 = { {"O", "O", "X"},
                              {"O", "X", "X"}, 
                              {"X", "O", "X"}};

    String[][] ticTacToe3 = { {"X", "O", "O"},
                              {"O", "X", "X"}, 
                              {"X", "O", "X"}};

    if (Arrays.deepEquals(ticTacToe, ticTacToe2)) {
      System.out.println("Plansze 1 i 2 s rwne.");
    } else {
      System.out.println("Plansze 1 i 2 nie s rwne.");
    }

    if (Arrays.deepEquals(ticTacToe, ticTacToe3)) {
      System.out.println("Plansze 1 i 3 s rwne.");
    } else {
      System.out.println("Plansze 1 i 3 nie s rwne.");
    }
  }
}