package com.oreilly.tiger.ch10;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LinkList<E> {

  // Warto wza
  E value;

  // Pozostaa cz listy
  LinkList<E> rest;
 
  // Blokada wza
  Lock lock;

  // Sygnalizuje zmian wartoci wza
  Condition valueChanged;

  // Sygnalizuje zmian wartoci wza poczonego
  Condition linkChanged;

  public LinkList(E value) {
    this.value = value;
    rest = null;
    lock = new ReentrantLock();
    valueChanged = lock.newCondition();
    linkChanged = lock.newCondition();
  }

  public void setValue(E value) {
    lock.lock();
    try {
      this.value = value;

      // Powiadamia oczekujce wtki o zmianie wartoci
      valueChanged.signalAll();
    } finally {
      lock.unlock();
    }
  }

  public void executeOnValue(E desiredValue, Runnable task)
    throws InterruptedException {
 
    lock.lock();
    try {
      // Porwnuje warto wza z wartoci podan
      while (!value.equals(desiredValue)) {
        // Oczekiwanie do momentu zmiany wartoci
        valueChanged.await();
      }

      // tutaj warto jest ju poprawna i mona wykona zadanie
      task.run();
    } finally {
      lock.unlock();
    }
  }

  public void append(E value) {
    // Rozpoczyna od tego wza
    LinkList<E> node = this;
    node.lock.lock();

    while (node.rest != null) {
      LinkList<E> next = node.rest;

      // Przekazywanie blokady
      try {
        // Blokuje nastpny wze
        next.lock.lock();
      } finally {
        // Zwalnia blokad biecego wza
        node.lock.unlock();
      }

      // Przechodzi do nastpnego wza
      node = next;      
    }

    // dociera do ostatniego wza, docza wze i zwalnia blokad
    try {
      node.rest = new LinkList<E>(value);

      // Informuje oczekujce wtki o zmianie poczenia wza
      node.linkChanged.signalAll();
    } finally {
      node.lock.unlock();
    }
  }

  public void printUntilInterrupted(String prefix) {
    // Rozpoczyna od tego wza
    LinkList<E> node = this;
    node.lock.lock();

    while (true) {
      LinkList<E> next;
      try {
        System.out.println(prefix + ": " + node.value);

        // Oczekuje na nastpny wze jeli nie jest dostpny

        while (node.rest == null) {
          node.linkChanged.await();
        }

        // Pobiera nastpny wze
        next = node.rest;

        // Blokuje dostp do niego

        next.lock.lock();
      } catch (InterruptedException e) {
        // Zeruje status przerwania
        Thread.currentThread().interrupt();
        return;
      } finally {
        node.lock.unlock();
      }

      // Przechodzi do nastpnego wza
      node = next;
    }
  }
}