package com.oreilly.tiger.ch07;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ForInTester {

  public ForInTester() {
  }

  public List getList() {
    List list = new LinkedList();

    for (int i = 1; i <= 100; i++) {
      list.add("Item " + i);
    }

    return list;
  }

  /**
   * <p>Testuje prost ptl for</p>
   */
  public void testForLoop(PrintStream out) throws IOException {
    List list = getList(); // inicjalizuje list

    for (Iterator i = list.iterator(); i.hasNext(); ) {
      Object listElement = i.next();
      out.println(listElement.toString());

      // Przetwarza element listy
    }
  }

  /**
   * <p>Testuje prost ptl for/in</p>
   */
  public void testForInLoop(PrintStream out) throws IOException {
    List list = getList(); // Inicjalizuje list

    for (Object listElement : list) {
      out.println(listElement.toString());

      // Przetwarza element listy
    }
  }

  /**
   * <p>Testuje przegldanie prostej tablicy</p>
   */
  public void testArrayLooping(PrintStream out) throws IOException {
    int[] primes = new int[] { 2, 3, 5, 7, 11, 13, 17, 19, 23, 29 };
    
    // Wywietla liczby pierwsze w ptli for/in
    for (int n : primes) {
      out.println(n);
    }
  }

  /**
   * <p>Testuje przegldanie tablicy obiektw</p>
   */
  public void testObjectArrayLooping(PrintStream out) throws IOException {
    List[] list_array = new List[3];

    list_array[0] = getList();
    list_array[1] = getList();
    list_array[2] = getList();

    for (List l : list_array) {
      out.println(l.getClass().getName());
    }
  }

  /**
   * <p>Prezentuje pozycj elementw na licie (niemoliwe w ptli for/in)</p>
   */
  public void determineListPosition(PrintStream out, String[] args) 
    throws IOException {

    List<String> wordList = new LinkedList<String>();

    // Nie jest moliwe przypisywanie, poniewa stosowany jest iterator
    for (int i=0; i<args.length; i++) {
      wordList.add("wyraz " + (i+1) + ": '" + args[i] + "'");
    }

    // W ptli for/in moemy wywietla, ale nie przypisywa
    for (String word : wordList) {
      out.println(word);
    }

    StringBuffer longList = new StringBuffer();
    for (int i = 0, len=wordList.size(); i < len; i++) {
      if (i < (len-1)) {
        longList.append(wordList.get(i))
                .append(", ");
      } else {
        longList.append(wordList.get(i));
      }
    }
    out.println(longList);
  }

  /**
   * <p>W ptli for/in nie mona usuwa elementw uywajc iteratora</p>
   */
  public void removeListItems(PrintStream out, String[] args) 
    throws IOException {

    List<String> wordList = new LinkedList<String>();

    // Umieszcza sowa na licie
    for (int i=0; i<args.length; i++) {
      wordList.add("word " + (i+1) + ": '" + args[i] + "'");
    }

    // Usuwa wszystkie sowa zawierajce "1". Niemoliwe w ptli for/in
    for (Iterator i = wordList.iterator(); i.hasNext(); ) {
      String word = (String)i.next();
      if (word.indexOf("1") != -1) {
        i.remove();
      }
    }

    // Wyswietla sowa w ptli for/in
    for (String word : wordList) {
      out.println(word);
    }
  }

  public static void main(String[] args) {
    try {
      ForInTester tester = new ForInTester();

      tester.testForLoop(System.out);
      tester.testForInLoop(System.out);

      tester.testArrayLooping(System.out);
      tester.testObjectArrayLooping(System.out);

      tester.determineListPosition(System.out, args);
      tester.removeListItems(System.out, args);
      
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}