package com.oreilly.tiger.ch03;

import java.io.IOException;
import java.io.PrintStream;
import java.util.EnumMap;

public class AntStatusTester {

  public AntStatusTester() { }

  public void testEnumMap(PrintStream out) throws IOException {
    // Tworzy map komunikatw
    EnumMap<AntStatus, String> antMessages =
      new EnumMap<AntStatus, String>(AntStatus.class);

    // Inicjalizuje map
    antMessages.put(AntStatus.INITIALIZING, "Inicjalizacja Ant...");
    antMessages.put(AntStatus.COMPILING,    "Kompilacja klas Java...");
    antMessages.put(AntStatus.COPYING,      "Kopiowanie plikw...");
    antMessages.put(AntStatus.JARRING,      "Tworzenie pliku JAR...");
    antMessages.put(AntStatus.ZIPPING,      "Tworzenie pliku ZIP...");
    antMessages.put(AntStatus.DONE,         "Koniec.");
    antMessages.put(AntStatus.ERROR,        "Wystpi bd.");

    // Przeglda map i wywietla komunikaty
    for (AntStatus status : AntStatus.values() ) {
      out.println("Dla kodu statusu " + status + ", komunikat brzmi: " +
                  antMessages.get(status));
    }
  }

  public static void main(String[] args) {
    try {
      AntStatusTester tester = new AntStatusTester();

      tester.testEnumMap(System.out);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
}