// Znajdowanie "optymalnego" rozwizania metod najmniejszego kosztut.
import java.util.*;
import java.io.*;

// Informacje o locie.
class FlightInfo {
  String from;
  String to;
  int distance;
  boolean skip; // uywane przy wycofywaniu

  FlightInfo(String f, String t, int d) {
    from = f;
    to = t;
    distance = d;
    skip = false;
  }
}

class Optimal {
  final int MAX = 100;

  // Tablica z informacjami o lotach.
  FlightInfo flights[] = new FlightInfo[MAX]; 

  int numFlights = 0; // liczba wpisw w tablicy

  Stack btStack = new Stack(); // stos powrotu

  Stack optimal; // przechowuje otymalne rozwizanie

  int minDist = 10000;

  public static void main(String args[])
  {    
    String to, from;
    Optimal ob = new Optimal();
    BufferedReader br = new 
      BufferedReader(new InputStreamReader(System.in)); 
    boolean done = false;
    FlightInfo f;

    ob.setup();  

    try { 
      System.out.print("Z? ");
      from = br.readLine(); 
      System.out.print("Do? ");
      to = br.readLine(); 
      do {
        ob.isflight(from, to);

        if(ob.btStack.size() == 0) done = true;
        else {
          ob.route(to);
          ob.btStack = new Stack();
        }
      } while(!done);

      // Wywietlenie rozwizanai optymalnego.
      if(ob.optimal != null) {
        System.out.println("Rozwizanie optymalne: ");

        int num = ob.optimal.size();
        for(int i=0; i < num; i++) {
          f = (FlightInfo) ob.optimal.pop();
          System.out.print(f.from + " do ");
        }

        System.out.println(to);
        System.out.println("Odlego to " + ob.minDist);
      }
    } catch (IOException exc) { 
      System.out.println("Bd wejcia.");
    }
  }
  
  // Inicjalizacja bazy danych lotw.
  void setup()
  {
    addFlight("New York", "Chicago", 900);
    addFlight("Chicago", "Denver", 1000);
    addFlight("New York", "Toronto", 500);
    addFlight("New York", "Denver", 1800);
    addFlight("Toronto", "Calgary", 1700);
    addFlight("Toronto", "Los Angeles", 2500);
    addFlight("Toronto", "Chicago", 500);
    addFlight("Denver", "Urbana", 1000);
    addFlight("Denver", "Houston", 1000);
    addFlight("Houston", "Los Angeles", 1500);
    addFlight("Denver", "Los Angeles", 1000);
  }
  
  // Umieszczenie lotw w bazie danych.
  void addFlight(String from, String to, int dist)
  {
    if(numFlights < MAX) {
      flights[numFlights] =
        new FlightInfo(from, to, dist);

      numFlights++;
    }
    else System.out.println("Baza danych pena.\n");
  }

  // Zapamitanie najkrtszej drogi.
  void route(String to)
  {
    int dist = 0;
    FlightInfo f;
    int num = btStack.size();
    Stack optTemp = new Stack();

    for(int i=0; i < num; i++) {
      f = (FlightInfo) btStack.pop();
      optTemp.push(f); // zapamitanie drogi
      dist += f.distance;
    }

    // Jeli krtsza, zapamitaj t drog.
    if(minDist > dist) {
      optimal = optTemp;
      minDist = dist;
    }         
  }

  /* Jeeli istnieje lot midzy z i do,
     zwr odlego dla tego lotu;
     w przeciwnym razie zwr 0. */
  int match(String from, String to)
  {
    for(int i=numFlights-1; i > -1; i--) {
      if(flights[i].from.equals(from) &&
         flights[i].to.equals(to) &&
         !flights[i].skip)
      {
        flights[i].skip = true; // zapobieganie ponownemu uyciu
        return flights[i].distance;
      }
    }
  
    return 0; // nie znaleziono 
  }
  
  // Dla danego z, znajd dowolne poczenie metod najmniejszego kosztu.
  FlightInfo find(String from)
  {
    int pos = -1;
    int dist = 10000; // dusze ni najdusza droga

    for(int i=0; i < numFlights; i++) {
      if(flights[i].from.equals(from) &&
         !flights[i].skip)
      {
        if(flights[i].distance < dist) {
          pos = i;
          dist = flights[i].distance;
        }
      }
    }

    if(pos != -1) {
      flights[pos].skip = true; // zapobieganie ponownemu uyciu
      FlightInfo f = new FlightInfo(flights[pos].from,
                           flights[pos].to,
                           flights[pos].distance);
      return f;
    }

    return null;
  }
  
  // Sprawdzenie drogi midzy z i do. 
  void isflight(String from, String to)
  {
    int dist;
    FlightInfo f;

    // Sprawdzenie, czy miejsce docelowe.
    dist = match(from, to);
    if(dist != 0) {      
      btStack.push(new FlightInfo(from, to, dist));
      return;
    }

    // Sprawdzenie innego poczenia.
    f = find(from);
    if(f != null) {
      btStack.push(new FlightInfo(from, to, f.distance));
      isflight(f.to, to);
    }
    else if(btStack.size() > 0) {
      // Powrt i sprawdzenie innego poczenia.
      f = (FlightInfo) btStack.pop();
      isflight(f.from, f.to);
    }
  }
}  
  