// Prosty aplet obliczania rat poyczki.  
import java.awt.*;  
import java.awt.event.*;  
import java.applet.*;  
import java.text.*;  
/*  
  <applet code="RegPay" width=280 height=200>  
  </applet>  
*/  
  
public class RegPay extends Applet  
  implements ActionListener {  
  
  TextField amountText, paymentText, periodText, 
            rateText; 
  Button doIt;  
  
  double principal; // kwota kredytu 
  double intRate;   // oprocentowanie w skali roku 
  double numYears;  // dugo spaty rat w latach 
 
  /* Liczba rat w cigu roku. Mona 
     umoliwi ustalenie tej wartoci przez uytkownika. */ 
  final int payPerYear = 12; 
 
  NumberFormat nf; 
 
  public void init() {  
    // Zastosowanie ukadu grid bag. 
    GridBagLayout gbag = new GridBagLayout(); 
    GridBagConstraints gbc = new GridBagConstraints(); 
    setLayout(gbag); 
 
    Label heading = new  
          Label("Obliczanie miesicznej raty poyczki"); 
  
    Label amountLab = new Label("Kwota poyczki"); 
    Label periodLab = new Label("Lata"); 
    Label rateLab = new Label("Oprocentowanie"); 
    Label paymentLab = new Label("Miesiczna rata"); 
 
    amountText = new TextField(16);  
    periodText = new TextField(16);  
    paymentText = new TextField(16);  
    rateText = new TextField(16); 
 
    // Pole raty tylko do odczytu. 
    paymentText.setEditable(false); 
 
    doIt = new Button("Oblicz");  
 
    // Zdefiniowanie ukadu graficznedgo okna. 
    gbc.weighty = 1.0; // waga wiersza rwna 1 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbc.anchor = GridBagConstraints.NORTH; 
    gbag.setConstraints(heading, gbc); 
 
    // Dowi wikszo komponentw do prawej strony. 
    gbc.anchor = GridBagConstraints.EAST; 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(amountLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(amountText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(periodLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(periodText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(rateLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(rateText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(paymentLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(paymentText, gbc); 
 
    gbc.anchor = GridBagConstraints.CENTER; 
    gbag.setConstraints(doIt, gbc); 
 
    // Dodaj komponenty. 
    add(heading);  
    add(amountLab);  
    add(amountText);  
    add(periodLab);  
    add(periodText); 
    add(rateLab); 
    add(rateText); 
    add(paymentLab);  
    add(paymentText);  
    add(doIt);  
  
    // Rejestracja w celu otrzymywania zdarze. 
    amountText.addActionListener(this);  
    periodText.addActionListener(this);  
    rateText.addActionListener(this);  
    doIt.addActionListener(this);      
 
    nf = NumberFormat.getInstance(); 
    nf.setMinimumFractionDigits(2); 
    nf.setMaximumFractionDigits(2); 
  }  
  
  /* Uytkownik nacisn Enter w polu tekstowym lub klikn 
     przycisk Oblicz. */ 
  public void actionPerformed(ActionEvent ae) {  
    repaint();  
  }  
 
  // Wywietl wynik, jeli wypeniono wszytkie pola.  
  public void paint(Graphics g) {  
    double result = 0.0; 
 
    String amountStr = amountText.getText();  
    String periodStr = periodText.getText();  
    String rateStr = rateText.getText(); 
 
    try {  
      if(amountStr.length() != 0 && 
         periodStr.length() != 0 && 
         rateStr.length() != 0) { 
 
        principal = Double.parseDouble(amountStr); 
        numYears = Double.parseDouble(periodStr);      
        intRate = Double.parseDouble(rateStr) / 100; 
 
        result = compute();   
  
        paymentText.setText(nf.format(result));  
      } 
  
      showStatus(""); // Usu poprzedni komunikat bdu  
    } catch (NumberFormatException exc) {  
      showStatus("Bdne dane"); 
      paymentText.setText("");  
    }  
  } 
 
  // Obliczenie raty. 
  double compute() { 
    double numer; 
    double denom; 
    double b, e; 
 
    numer = intRate * principal / payPerYear;   
    
    e = -(payPerYear * numYears);   
    b = (intRate / payPerYear) + 1.0;   
   
    denom = 1.0 - Math.pow(b, e);   
 
    return numer / denom;   
  }     
}

