/* Oblicza, ile trzeba zainwestowa, aby uzyska 
   po jakim czasie dan warto.  */ 
import java.awt.*;  
import java.awt.event.*;  
import java.applet.*;  
import java.text.*;  
/*  
  <applet code="InitInv" width=340 height=240>  
  </applet>  
*/  
  
public class InitInv extends Applet  
  implements ActionListener {  
  
  TextField targetText, initialText, periodText, 
            rateText, compText; 
  Button doIt;  
  
  double targetValue; // kwota docelowa 
  double rateOfRet;   // stopa zysku 
  double numYears;    // dugo czasu oszczdzania 
  int compPerYear;    // kapitalizacji w roku 
 
  NumberFormat nf; 
 
  public void init() {  
    // Zastosowanie ukadu grid bag. 
    GridBagLayout gbag = new GridBagLayout(); 
    GridBagConstraints gbc = new GridBagConstraints(); 
    setLayout(gbag); 
 
    Label heading = new  
          Label("Pocztkowa inwestycja dla osignicia " + 
                "danej wartoci w przyszoci"); 
  
    Label targetLab = new Label("Warto w przyszoci "); 
    Label periodLab = new Label("Lat"); 
    Label rateLab = new Label("Stopa zysku");  
    Label compLab = 
            new Label("Kapitalizacji w roku"); 
    Label initialLab =  
            new  Label("Wymagany wkad poczatkowy"); 
 
    targetText = new TextField(16);  
    periodText = new TextField(16);  
    initialText = new TextField(16);  
    rateText = new TextField(16); 
    compText = new TextField(16); 
 
    // Pole wyniku tylko do odczytu. 
    initialText.setEditable(false); 
 
    doIt = new Button("Oblicz");  
  
    // Definiowanie siatki. 
    gbc.weighty = 1.0; // zastosowanie wagi wiersza o wartoci 1 
 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbc.anchor = GridBagConstraints.NORTH; 
    gbag.setConstraints(heading, gbc); 
 
    // Dowizanie wikszoci komponentw do prawej. 
    gbc.anchor = GridBagConstraints.EAST; 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(targetLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(targetText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(periodLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(periodText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(rateLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(rateText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(compLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(compText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(initialLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(initialText, gbc); 
 
    gbc.anchor = GridBagConstraints.CENTER; 
    gbag.setConstraints(doIt, gbc); 
 
    // Dodanie komponentw do okna. 
    add(heading);  
    add(targetLab);  
    add(targetText);  
    add(periodLab);  
    add(periodText); 
    add(rateLab); 
    add(rateText); 
    add(compLab);  
    add(compText);  
    add(initialLab);  
    add(initialText);  
    add(doIt);  
  
    // Rejestracja nasuchiwania zdarze. 
    targetText.addActionListener(this);  
    periodText.addActionListener(this);  
    rateText.addActionListener(this);  
    compText.addActionListener(this);  
    doIt.addActionListener(this);      
 
    nf = NumberFormat.getInstance(); 
    nf.setMinimumFractionDigits(2); 
    nf.setMaximumFractionDigits(2); 
  }  
  
  /* Uytkownik nacisn Enter w polu tekstowym lub klikn 
     przycisk Oblicz. */ 
  public void actionPerformed(ActionEvent ae) {  
    repaint();  
  }  
  
  public void paint(Graphics g) {  
    double result = 0.0; 
 
    String targetStr = targetText.getText();  
    String periodStr = periodText.getText();  
    String rateStr = rateText.getText(); 
    String compStr = compText.getText(); 
 
    try {  
      if(targetStr.length() != 0 && 
         periodStr.length() != 0 && 
         rateStr.length() != 0 && 
         compStr.length() != 0) { 
 
        targetValue = Double.parseDouble(targetStr); 
        numYears = Double.parseDouble(periodStr);      
        rateOfRet = Double.parseDouble(rateStr) / 100; 
        compPerYear = Integer.parseInt(compStr); 
 
        result = compute();   
  
        initialText.setText(nf.format(result));  
      } 
  
      showStatus(""); // usunicie wczeniejszego komunikatu bdu  
    } catch (NumberFormatException exc) {  
      showStatus("Bdne dane"); 
      initialText.setText("");  
    }  
  } 
 
  // Obliczenie kwoty do zainwestowania. 
  double compute() { 
    double b, e; 
 
    b = (1 + rateOfRet/compPerYear); 
    e = compPerYear * numYears; 
 
    return targetValue / Math.pow(b, e);   
  }    
  
}

