// Oblicza przysz warto inwestycji. 
import java.awt.*;  
import java.awt.event.*;  
import java.applet.*;  
import java.text.*;  
/*  
  <applet code="FutVal" width=340 height=240>  
  </applet>  
*/  
  
public class FutVal extends Applet  
  implements ActionListener {  
  
  TextField amountText, futvalText, periodText, 
            rateText, compText; 
  Button doIt;  
  
  double principal; // wkad pocztkowy 
  double rateOfRet; // stopa zysku 
  double numYears;  // okres inwestowania w latach 
  int compPerYear;  // liczba kapitalizacji w roku 
 
  NumberFormat nf; 
 
  public void init() {  
    // Zastosowanie ukadu grid bag. 
    GridBagLayout gbag = new GridBagLayout(); 
    GridBagConstraints gbc = new GridBagConstraints(); 
    setLayout(gbag); 
 
    Label heading = new  
          Label("Przysza warto inwestycji"); 
  
    Label amountLab = new Label("Wkad pocztkowy");  
    Label periodLab = new Label("Lat");  
    Label rateLab = new Label("Stopa zysku");  
    Label futvalLab = 
            new Label("Przysza warto inwestycji"); 
    Label compLab = 
            new Label("Liczba kapitalizacji w roku"); 
 
    amountText = new TextField(16);  
    periodText = new TextField(16);  
    futvalText = new TextField(16);  
    rateText = new TextField(16); 
    compText = new TextField(16); 
 
    // Pole raty tylko do odczytu. 
    futvalText.setEditable(false); 
 
    doIt = new Button("Oblicz");  
 
    // Zdefiniowanie ukdu graficznego okna. 
    gbc.weighty = 1.0; // zastosowanie wagi wiersza rwnej 1 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbc.anchor = GridBagConstraints.NORTH; 
    gbag.setConstraints(heading, gbc); 
 
    // Dowizanie wikszoci wierszy do prawej strony. 
    gbc.anchor = GridBagConstraints.EAST; 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(amountLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(amountText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(periodLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(periodText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(rateLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(rateText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(compLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(compText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(futvalLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(futvalText, gbc); 
 
    gbc.anchor = GridBagConstraints.CENTER; 
    gbag.setConstraints(doIt, gbc); 
  
    add(heading);  
    add(amountLab);  
    add(amountText);  
    add(periodLab);  
    add(periodText); 
    add(rateLab); 
    add(rateText); 
    add(compLab);  
    add(compText);  
    add(futvalLab);  
    add(futvalText);  
    add(doIt);  
  
    // Rejestracja nasuchiwania zdarze. 
    amountText.addActionListener(this);  
    periodText.addActionListener(this);  
    rateText.addActionListener(this);  
    compText.addActionListener(this);  
    doIt.addActionListener(this);      
 
    nf = NumberFormat.getInstance(); 
    nf.setMinimumFractionDigits(2); 
    nf.setMaximumFractionDigits(2); 
  }  
  
  /* Uytkownik nacisn Enter w polu tekstowym lub klikn 
     przycisk Oblicz. */ 
  public void actionPerformed(ActionEvent ae) {  
    repaint();  
  }  
  
  public void paint(Graphics g) {  
    double result = 0.0; 
 
    String amountStr = amountText.getText();  
    String periodStr = periodText.getText();  
    String rateStr = rateText.getText(); 
    String compStr = compText.getText(); 
 
    try {  
      if(amountStr.length() != 0 && 
         periodStr.length() != 0 && 
         rateStr.length() != 0 && 
         compStr.length() != 0) { 
 
        principal = Double.parseDouble(amountStr); 
        numYears = Double.parseDouble(periodStr);      
        rateOfRet = Double.parseDouble(rateStr) / 100; 
        compPerYear = Integer.parseInt(compStr); 
 
        result = compute();   
  
        futvalText.setText(nf.format(result));  
      } 
  
      showStatus(""); // usuwa wczeniejszy komunikat bdu 
    } catch (NumberFormatException exc) {  
      showStatus("Bdne dane"); 
      futvalText.setText("");  
    }  
  } 
 
  // Oblicza warto inwestycji. 
  double compute() { 
    double b, e; 
 
    b = (1 + rateOfRet/compPerYear); 
    e = compPerYear * numYears; 
 
    return principal * Math.pow(b, e);   
  }    
}

