/* Obliczenie pocztkowej inwestycji w celu 
   uzyskiwania danej emerytury. Innymi sowy znajdujemy 
   poczatkow kwot inwestycji pozwalajc wypaca 
   dankwot emerytury przez okrelony okres czasu.  */ 
import java.awt.*;  
import java.awt.event.*;  
import java.applet.*;  
import java.text.*;  
/*  
  <applet code="Annuity" width=340 height=260>  
  </applet>  
*/  
  
public class Annuity extends Applet  
  implements ActionListener {  
  
  TextField regWDText, initialText, periodText, 
            rateText, numWDText; 
  Button doIt;  
  
  double regWDAmount; // kwota emerytury 
  double rateOfRet;   // stopa zysku 
  double numYears;    // liczba lat
  int numPerYear;     // wypat w roku 
 
  NumberFormat nf; 
 
  public void init() {  
    // Zastosowanie ukadu grid bag. 
    GridBagLayout gbag = new GridBagLayout(); 
    GridBagConstraints gbc = new GridBagConstraints(); 
    setLayout(gbag); 
 
    Label heading = new  
          Label("Inwestycja pocztkowa dla " + 
                "reguralnej emerytury");  
  
    Label regWDLab = new Label("Podana emerytura"); 
    Label periodLab = new Label("Lat"); 
    Label rateLab = new Label("Stopa zysku"); 
    Label numWDLab = 
            new Label("Liczba wypat w roku"); 
    Label initialLab = 
            new Label("Wymagana inwestycja pocztkowa"); 
 
    regWDText = new TextField(16);  
    periodText = new TextField(16);  
    initialText = new TextField(16);  
    rateText = new TextField(16); 
    numWDText = new TextField(16); 
 
    // Wpole wyniku tylko do odczytu. 
    initialText.setEditable(false); 
 
    doIt = new Button("Oblicz");  
  
    // Zdefiniowanie siatki. 
 
    gbc.weighty = 1.0; // waga wiersza rwna 1 
 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbc.anchor = GridBagConstraints.NORTH; 
    gbag.setConstraints(heading, gbc); 
 
    // Dowizanie wikszoci komponentw do prawej strony. 
    gbc.anchor = GridBagConstraints.EAST; 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(regWDLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(regWDText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(periodLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(periodText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(rateLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(rateText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(numWDLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(numWDText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(initialLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(initialText, gbc); 
 
    gbc.anchor = GridBagConstraints.CENTER; 
    gbag.setConstraints(doIt, gbc); 
 
    // Dodanie wszystkich komponentw. 
    add(heading);  
    add(regWDLab);  
    add(regWDText);  
    add(periodLab);  
    add(periodText); 
    add(rateLab); 
    add(rateText); 
    add(numWDLab);  
    add(numWDText);  
    add(initialLab);  
    add(initialText);  
    add(doIt);  
  
    // Rejestracja w celu odbieranai zdarze. 
    regWDText.addActionListener(this);  
    periodText.addActionListener(this);  
    rateText.addActionListener(this);  
    numWDText.addActionListener(this);  
    doIt.addActionListener(this);      
 
    nf = NumberFormat.getInstance(); 
    nf.setMinimumFractionDigits(2); 
    nf.setMaximumFractionDigits(2); 
  }  
  
  /* Uytkownik nacisn Enter w polu tekstowym lub klikn 
     przycisk Oblicz. */
  public void actionPerformed(ActionEvent ae) {  
    repaint();  
  }  
  
  public void paint(Graphics g) {  
    double result = 0.0; 
 
    String regWDStr = regWDText.getText();  
    String periodStr = periodText.getText();  
    String rateStr = rateText.getText(); 
    String numWDStr = numWDText.getText(); 
 
    try {  
      if(regWDStr.length() != 0 && 
         periodStr.length() != 0 && 
         rateStr.length() != 0 && 
         numWDStr.length() != 0) { 
 
        regWDAmount = Double.parseDouble(regWDStr); 
        numYears = Double.parseDouble(periodStr);      
        rateOfRet = Double.parseDouble(rateStr) / 100; 
        numPerYear = Integer.parseInt(numWDStr); 
 
        result = compute();   
  
        initialText.setText(nf.format(result));  
      } 
  
      showStatus(""); // usunicie poprzedniego komunikatu bdu  
    } catch (NumberFormatException exc) {  
      showStatus("Bdne dane"); 
      initialText.setText("");  
    }  
  } 
 
  // Obliczenie wymaganej inwestycji. 
  double compute() { 
    double b, e; 
    double t1, t2; 
 
    t1 = (regWDAmount * numPerYear) / rateOfRet; 
 
    b = (1 + rateOfRet/numPerYear); 
    e = numPerYear * numYears; 
 
    t2 = 1 - (1 / Math.pow(b, e)); 
     
    return t1 * t2; 
  }    
}

