import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/* Ta klasa wywietla okno z ustawieniami 
   poczenia z serwerem. */
public class ConnectDialog extends JDialog
{
  // Rodzaje pocze z serwerem.
  private static final String[] TYPES = {"pop3", "imap"};

  // Lista rozwijana dla typw pocze.
  private JComboBox typeComboBox;

  // Pola tekstowe serwera, nazwy uytkownika i serwera SMTP.
  private JTextField serverTextField, usernameTextField;
  private JTextField smtpServerTextField;

  // Pole tekstowe hasa.
  private JPasswordField passwordField;

  // Konstruktor okna.
  public ConnectDialog(Frame parent)
  {
    // Wywoanie konstruktora nadrzdnego, wskazanie, i 
	// okno jest typu modal.
    super(parent, true);

    // Ustawienie tytuu.
    setTitle("Poczenie");

    // Obsuga zdarzenia zamknicia.
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        actionCancel();
      }
    });

    // Tworzenie panelu ustawiw.
    JPanel settingsPanel = new JPanel();
    settingsPanel.setBorder(
      BorderFactory.createTitledBorder("Ustawienia poczenia"));
    GridBagConstraints constraints;
    GridBagLayout layout = new GridBagLayout();
    settingsPanel.setLayout(layout);
    JLabel typeLabel = new JLabel("Typ:");
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.EAST;
    constraints.insets = new Insets(5, 5, 0, 0);
    layout.setConstraints(typeLabel, constraints);
    settingsPanel.add(typeLabel);
    typeComboBox = new JComboBox(TYPES);
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.WEST;
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.insets = new Insets(5, 5, 0, 5);
    constraints.weightx = 1.0D;
    layout.setConstraints(typeComboBox, constraints);
    settingsPanel.add(typeComboBox);
    JLabel serverLabel = new JLabel("Serwer:");
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.EAST;
    constraints.insets = new Insets(5, 5, 0, 0);
    layout.setConstraints(serverLabel, constraints);
    settingsPanel.add(serverLabel);
    serverTextField = new JTextField(25);
    constraints = new GridBagConstraints();
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.insets = new Insets(5, 5, 0, 5);
    constraints.weightx = 1.0D;
    layout.setConstraints(serverTextField, constraints);
    settingsPanel.add(serverTextField);
    JLabel usernameLabel = new JLabel("Uytkownik:");
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.EAST;
    constraints.insets = new Insets(5, 5, 0, 0);
    layout.setConstraints(usernameLabel, constraints);
    settingsPanel.add(usernameLabel);
    usernameTextField = new JTextField();
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.WEST;
    constraints.fill = GridBagConstraints.HORIZONTAL;
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.insets = new Insets(5, 5, 0, 5);
    constraints.weightx = 1.0D;
    layout.setConstraints(usernameTextField, constraints);
    settingsPanel.add(usernameTextField);
    JLabel passwordLabel = new JLabel("Haso:");
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.EAST;
    constraints.insets = new Insets(5, 5, 5, 0);
    layout.setConstraints(passwordLabel, constraints);
    settingsPanel.add(passwordLabel);
    passwordField = new JPasswordField();
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.WEST;
    constraints.fill = GridBagConstraints.HORIZONTAL;
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.insets = new Insets(5, 5, 5, 5);
    constraints.weightx = 1.0D;
    layout.setConstraints(passwordField, constraints);
    settingsPanel.add(passwordField);
    JLabel smtpServerLabel = new JLabel("Serwer SMTP:");
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.EAST;
    constraints.insets = new Insets(5, 5, 5, 0);
    layout.setConstraints(smtpServerLabel, constraints);
    settingsPanel.add(smtpServerLabel);
    smtpServerTextField = new JTextField(25);
    constraints = new GridBagConstraints();
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.insets = new Insets(5, 5, 5, 5);
    constraints.weightx = 1.0D;
    layout.setConstraints(smtpServerTextField, constraints);
    settingsPanel.add(smtpServerTextField);

    // Panel przyciskw.
    JPanel buttonsPanel = new JPanel();
    JButton connectButton = new JButton("Pocz");
    connectButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        actionConnect();
      }
    });
    buttonsPanel.add(connectButton);
    JButton cancelButton = new JButton("Anuluj");
    cancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        actionCancel();
      }
    });
    buttonsPanel.add(cancelButton);

    // Dodanie paneli.
    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(settingsPanel, BorderLayout.CENTER);
    getContentPane().add(buttonsPanel, BorderLayout.SOUTH);

    // Dostosowanie rozmiaru do komponentw.
    pack();

    // Wyrodkowanie wzgldem aplikacji.
    setLocationRelativeTo(parent);
  }

  // Sprawdzenie parametrw i zamknicie okna.
  private void actionConnect() {
    if (serverTextField.getText().trim().length() < 1
        || usernameTextField.getText().trim().length() < 1
        || passwordField.getPassword().length < 1
        || smtpServerTextField.getText().trim().length() < 1) {
      JOptionPane.showMessageDialog(this,
        "Brak jednego lub kilku ustawie.",
        "Brak ustawie", JOptionPane.ERROR_MESSAGE);
      return;
    }

    // Zamknicie okna.
    dispose();
  }

  // Anulowanie poczenia i wyjcie z programu.
  private void actionCancel() {
    System.exit(0);
  }

  // Pobranie typu serwera.
  public String getType() {
    return (String) typeComboBox.getSelectedItem();
  }

  // Pobranie serwera.
  public String getServer() {
    return serverTextField.getText();
  }

  // Pobranie nazwy uytkownika.
  public String getUsername() {
    return usernameTextField.getText();
  }

  // Pobranie hasa.
  public String getPassword() {
    return new String(passwordField.getPassword());
  }

  // Pobranie serwera SMTP.
  public String getSmtpServer() {
    return smtpServerTextField.getText();
  }
}
