/*   
   Ten modu zawiera analizator stosujcy schodzenie rekurencyjne  
   z wykorzystaniem zmiennych.  
*/  
   
// Klasa wyjtw dla bdw analizatora.  
class ParserException extends Exception {  
  String errStr; // opis bdu
 
  public ParserException(String str) { 
    errStr = str; 
  }   
  
  public String toString() {  
    return errStr; 
  }  
}  
  
class Parser {  
  // Rodzaje tokenw. 
  final int NONE = 0; 
  final int DELIMITER = 1; 
  final int VARIABLE = 2; 
  final int NUMBER = 3; 
 
  // Rodzaje bdw skaniowych. 
  final int SYNTAX = 0; 
  final int UNBALPARENS = 1; 
  final int NOEXP = 2; 
  final int DIVBYZERO = 3; 
 
  // Token oznaczajcy koniec wyraenia. 
  final String EOE = "\0"; 
 
  private String exp;   // teksty wyraenia  
  private int expIdx;   // aktualny indeks w wyraeniu  
  private String token; // aktualny token  
  private int tokType;  // typ tokenu  
  
  // Tablica zmiennych.  
  private double vars[] = new double[26];  
 
  // Pocztek analizatora.  
  public double evaluate(String expstr) throws ParserException 
  {  
    double result;  
    exp = expstr;  
    expIdx = 0;   
   
    getToken();  
    if(token.equals(EOE)) 
      handleErr(NOEXP); // brak wyraenia  
 
    // Przeanalizuj i oblicz wyraenie. 
    result = evalExp1();  
  
    if(!token.equals(EOE)) // ostatnim tokenem musi by EOE  
      handleErr(SYNTAX);  
  
    return result;  
  }  
    
  // Wykorzystanie zmiennych.  
  private double evalExp1() throws ParserException 
  {  
    double result; 
    int varIdx;  
    int ttokType;  
    String temptoken;  
  
    if(tokType == VARIABLE) {  
      // zapisz stary token  
      temptoken = new String(token);  
      ttokType = tokType;  
  
      // Oblicz indeks zmiennej.  
      varIdx = Character.toUpperCase(token.charAt(0)) - 'A';  
  
      getToken();  
      if(!token.equals("=")) {  
        putBack(); // zwr aktualny token  
        // przywr stary token -- brak przypisania
        token = new String(temptoken);  
        tokType = ttokType;  
      }  
      else {  
        getToken(); // pobierz nastpn cz wyraenia 
        result = evalExp2();  
        vars[varIdx] = result;  
        return result;  
      }  
    }  
  
    return evalExp2();  
  }  
 
  // Dodanie lub odjcie dwch elementw.  
  private double evalExp2() throws ParserException 
  {  
    char op;  
    double result; 
    double partialResult;  
 
    result = evalExp3();  
 
    while((op = token.charAt(0)) == '+' || op == '-') {  
      getToken();  
      partialResult = evalExp3();  
      switch(op) {  
        case '-':  
          result = result - partialResult;  
          break;  
        case '+':  
          result = result + partialResult;  
          break;  
      }  
    }  
    return result; 
  }  
    
  // Pomnoenie lub podzielenie dwch elementw.  
  private double evalExp3() throws ParserException 
  {  
    char op;  
    double result; 
    double partialResult;  
    
    result = evalExp4();  
 
    while((op = token.charAt(0)) == '*' ||  
           op == '/' || op == '%') {  
      getToken();  
      partialResult = evalExp4();  
      switch(op) {  
        case '*':  
          result = result * partialResult;  
          break;  
        case '/':  
          if(partialResult == 0.0)  
            handleErr(DIVBYZERO);  
          result = result / partialResult;  
          break;  
        case '%':  
          if(partialResult == 0.0)  
            handleErr(DIVBYZERO);  
          result = result % partialResult;  
          break;  
      }  
    }  
    return result; 
  }  
    
  // Przetworzenie potgowania.  
  private double evalExp4() throws ParserException 
  {  
    double result; 
    double partialResult; 
    double ex;  
    int t;  
    
    result = evalExp5();  
 
    if(token.equals("^")) {  
      getToken();  
      partialResult = evalExp4();  
      ex = result;  
      if(partialResult == 0.0) {  
        result = 1.0;  
      } else  
        for(t=(int)partialResult-1; t > 0; t--)  
          result = result * ex;  
    }  
    return result; 
  }  
    
  // Obliczenie pojedynczego + lub -.  
  private double evalExp5() throws ParserException 
  {  
    double result; 
    String  op;  
 
    op = "";  
    if((tokType == DELIMITER) &&  
        token.equals("+") || token.equals("-")) {  
      op = token;  
      getToken();  
    }  
    result = evalExp6();  
 
    if(op.equals("-")) result = -result; 
 
    return result;  
  }  
    
  // Obsuga wyrae z nawiasami.  
  private double evalExp6() throws ParserException 
  {  
    double result; 
 
    if(token.equals("(")) {  
      getToken();  
      result = evalExp2();  
      if(!token.equals(")"))  
        handleErr(UNBALPARENS);  
      getToken();  
    }  
    else result = atom();  
 
    return result; 
  }  
    
  // Pobranie wartoci liczby lub zmiennej.  
  private double atom() throws ParserException  
  {  
    double result = 0.0; 
 
    switch(tokType) {  
      case NUMBER:  
        try {  
          result = Double.parseDouble(token);  
        } catch (NumberFormatException exc) {  
          handleErr(SYNTAX);  
        }  
        getToken();  
        break; 
      case VARIABLE:  
        result = findVar(token);  
        getToken();  
        break;  
      default:  
        handleErr(SYNTAX);  
        break;  
    }  
    return result; 
  }  
    
   // Zwrcenie wartoci zmiennej.  
  private double findVar(String vname) throws ParserException 
  {  
    if(!Character.isLetter(vname.charAt(0))){  
      handleErr(SYNTAX);  
      return 0.0;  
    }  
    return vars[Character.toUpperCase(vname.charAt(0))-'A'];  
  }  
  
  // Zwrcenie tokenu do strumienia wejciowego.  
  private void putBack()    
  {  
    if(token == EOE) return; 
    for(int i=0; i < token.length(); i++) expIdx--;  
  }  
  
  // Obsuga bdu.  
  private void handleErr(int error) throws ParserException 
  {  
    String[] err = {  
      "Bd skadniowy",  
      "Brak jednego z nawiasw",  
      "Brak wyraenia",  
      "Dzielenie przez zero"  
    };  
  
    throw new ParserException(err[error]);  
  }  
    
  // Pobranie nastpnego tokenu.  
  private void getToken()  
  {  
    tokType = NONE;  
    token = "";  
     
    // Sprawdzenie koca wyraenia.  
    if(expIdx == exp.length()) { 
      token = EOE; 
      return; 
    } 
    
    // Pominicie biaych spacji. 
    while(expIdx < exp.length() &&  
      Character.isWhitespace(exp.charAt(expIdx))) ++expIdx;  
  
    // Pominicie spacji na kocu wyraenia. 
    if(expIdx == exp.length()) { 
      token = EOE; 
      return; 
    } 
  
    if(isDelim(exp.charAt(expIdx))) { // czy operator  
      token += exp.charAt(expIdx);  
      expIdx++;  
      tokType = DELIMITER;  
    }  
    else if(Character.isLetter(exp.charAt(expIdx))) { // czy zmienna 
      while(!isDelim(exp.charAt(expIdx))) {  
        token += exp.charAt(expIdx);  
        expIdx++;  
        if(expIdx >= exp.length()) break;  
      }  
      tokType = VARIABLE;  
    }  
    else if(Character.isDigit(exp.charAt(expIdx))) { // czy liczba  
      while(!isDelim(exp.charAt(expIdx))) {  
        token += exp.charAt(expIdx);  
        expIdx++;  
        if(expIdx >= exp.length()) break;  
      }  
      tokType = NUMBER;  
    }  
    else { // nieznany znak przerywa analiz 
      token = EOE; 
      return; 
    } 
  }  
    
  // Zwraca true, jeli c jest przerywnikiem.  
  private boolean isDelim(char c)  
  {  
    if((" +-/*%^=()".indexOf(c) != -1))  
      return true;  
    return false;  
  }  
}

