/* Obliczenie maksymalnych wypat emerytury 
   dla okrelonego okresu i zebranych pienidzy. */ 
import java.awt.*;  
import java.awt.event.*;  
import java.applet.*;  
import java.text.*;  
/*  
  <applet code="MaxWD" width=340 height=260>  
  </applet>  
*/  
  
public class MaxWD extends Applet  
  implements ActionListener {  
  
  TextField maxWDText, orgPText, periodText, 
            rateText, numWDText; 
  Button doIt;  
  
  double principal; // posiadana kwota 
  double rateOfRet; // roczna stopa zysku 
  double numYears;  // liczba lat 
  int numPerYear;   // liczba wypat w roku 
 
  NumberFormat nf; 
 
  public void init() {  
    // Zastosowanie ukadu grid bag. 
    GridBagLayout gbag = new GridBagLayout(); 
    GridBagConstraints gbc = new GridBagConstraints(); 
    setLayout(gbag); 
 
    Label heading = new  
          Label("Maksymalna emerytura"); 
  
    Label orgPLab = new Label("Posiadana kwota"); 
    Label periodLab = new Label("Lat"); 
    Label rateLab = new Label("Stopa zysku"); 
    Label numWDLab = 
           new Label("Liczba wypat w roku"); 
    Label maxWDLab = new Label("Maksymalna emerytura"); 
 
    maxWDText = new TextField(16);  
    periodText = new TextField(16);  
    orgPText = new TextField(16);  
    rateText = new TextField(16); 
    numWDText = new TextField(16); 
 
    // Pole wyniku tylko do odczytu. 
    maxWDText.setEditable(false); 
 
    doIt = new Button("Oblicz");  
 
    // Zdefiniowanie siatki. 
    gbc.weighty = 1.0; // waga wiersza rwna 1 
 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbc.anchor = GridBagConstraints.NORTH; 
    gbag.setConstraints(heading, gbc); 
 
    // Dowizanie wikszoci komponentw do prawej. 
    gbc.anchor = GridBagConstraints.EAST; 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(orgPLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(orgPText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(periodLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(periodText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(rateLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(rateText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(numWDLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(numWDText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(maxWDLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(maxWDText, gbc); 
 
    gbc.anchor = GridBagConstraints.CENTER; 
    gbag.setConstraints(doIt, gbc); 
  
    // Dodanie komponentw. 
    add(heading);  
    add(orgPLab);  
    add(orgPText);  
    add(periodLab);  
    add(periodText); 
    add(rateLab); 
    add(rateText); 
    add(numWDLab);  
    add(numWDText);  
    add(maxWDLab);  
    add(maxWDText);  
    add(doIt);  
  
    // Rejestracja w celu otrzymywanai zdarze. 
    orgPText.addActionListener(this);  
    periodText.addActionListener(this);  
    rateText.addActionListener(this);  
    numWDText.addActionListener(this);  
    doIt.addActionListener(this);      
 
    nf = NumberFormat.getInstance(); 
    nf.setMinimumFractionDigits(2); 
    nf.setMaximumFractionDigits(2); 
  }  
  
  /* Uytkownik nacisn Enter w polu tekstowym lub klikn 
     przycisk Oblicz. */ 
  public void actionPerformed(ActionEvent ae) {  
    repaint();  
  }  
  
  public void paint(Graphics g) {  
    double result = 0.0; 
 
    String orgPStr = orgPText.getText();  
    String periodStr = periodText.getText();  
    String rateStr = rateText.getText(); 
    String numWDStr = numWDText.getText(); 
 
    try {  
      if(orgPStr.length() != 0 && 
         periodStr.length() != 0 && 
         rateStr.length() != 0 && 
         numWDStr.length() != 0) { 
 
        principal = Double.parseDouble(orgPStr); 
        numYears = Double.parseDouble(periodStr);      
        rateOfRet = Double.parseDouble(rateStr) / 100; 
        numPerYear = Integer.parseInt(numWDStr); 
 
        result = compute();   
  
        maxWDText.setText(nf.format(result));  
      } 
  
      showStatus(""); // usunicie poprzedniego komunikatu  
    } catch (NumberFormatException exc) {  
      showStatus("Bdne dane"); 
      maxWDText.setText("");  
    }  
  } 
 
  // Obliczenie emerytury. 
  double compute() { 
    double b, e; 
    double t1, t2; 
 
    t1 = rateOfRet / numPerYear; 
 
    b = (1 + t1); 
    e = numPerYear * numYears; 
 
    t2 = Math.pow(b, e) - 1; 
     
    return principal * (t1/t2 + t1); 
  }    
}

