import java.awt.*; 
import java.awt.event.*; 
import java.util.*; 
import java.text.*; 
 
// Przetworzenie i wywietlenie danych statystycznych. 
public class StatsWin extends Frame 
    implements ItemListener, ActionListener  { 
 
  NumberFormat nf = NumberFormat.getInstance(); 
 
  TextArea statsTA; 
  Checkbox bar = new Checkbox("Wykres supkowy"); 
  Checkbox scatter = new Checkbox("wykres punktowy"); 
  Checkbox regplot = new Checkbox("Linia regresji"); 
  Checkbox datawin = new Checkbox("Poka dane"); 
 
  double[] data; 
 
  Graphs bg; 
  Graphs sg; 
  Graphs rp; 
  DataWin da; 
 
  RegData rd; 
 
  public StatsWin(double vals[]) { 
    data = vals; // zapamitaj referencj do danych 
 
    addWindowListener(new WindowAdapter() { 
      public void windowClosing(WindowEvent we) { 
        shutdown(); 
      } 
    }); 
 
    // Utworzenie menu. 
    createMenu(); 
 
    // Zmiana ukadu okna, centrowanie komponentw. 
    setLayout(new FlowLayout(FlowLayout.CENTER)); 
 
    setSize(new Dimension(300, 240)); 
    setTitle("Dane statystyczne"); 
    
    rd = Stats.regress(data); 
 
    // Ustawienie formatu z 2 miejscami po przecinku. 
    nf.setMaximumFractionDigits(2); 
 
 
    // Konstrukcja wyjcia. 
    String mstr; 
    try { 
      // Pobranie modalnej, jeli istnieje. 
      mstr = nf.format(Stats.mode(data)); 
    } catch(NoModeException exc) { 
      mstr = exc.toString(); 
    } 
 
    String str = "rednia: " + 
                  nf.format(Stats.mean(data)) + "\n" + 
                 "Mediana: " + 
                  nf.format(Stats.median(data)) + "\n" + 
                 "Modalna: " + mstr + "\n" + 
                 "Odchylenie standardowe: " + 
                  nf.format(Stats.stdDev(data)) + "\n\n" + 
                 "Rwnanie regresji: " + rd.equation + 
                 "\nWspczynnik korelacji: " + 
                  nf.format(rd.cor); 
 
    // Umieszczenie wyjcia w polu tekstowym. 
    statsTA = new TextArea(str, 6, 38, TextArea.SCROLLBARS_NONE); 
    statsTA.setEditable(false); 
 
    // Dodanie komponentw do okna. 
    add(statsTA);     
    add(bar); 
    add(scatter); 
    add(regplot); 
    add(datawin); 
 
    // Dodanie nasuchiwania. 
    bar.addItemListener(this); 
    scatter.addItemListener(this); 
    regplot.addItemListener(this); 
    datawin.addItemListener(this); 
 
    setVisible(true); 
  } 
 
  // Obsuga zamykania okna. 
  public void actionPerformed(ActionEvent ae) { 
    String arg = (String)ae.getActionCommand(); 
 
    if(arg == "Close") { 
      shutdown(); 
    } 
  } 
 
  // Uytkownik zmieni opcj. 
  public void itemStateChanged(ItemEvent ie) { 
    if(bar.getState()) { 
      if(bg == null) { 
        bg = new Graphs(data, Graphs.BAR); 
        bg.addWindowListener(new WindowAdapter() { 
          public void windowClosing(WindowEvent we) { 
            bar.setState(false); 
            bg = null; 
          } 
        }); 
      } 
    } 
    else { 
      if(bg != null) { 
        bg.dispose(); 
        bg = null; 
      } 
    } 
 
    if(scatter.getState()) { 
      if(sg == null) { 
        sg = new Graphs(data, Graphs.SCATTER); 
        sg.addWindowListener(new WindowAdapter() { 
          public void windowClosing(WindowEvent we) { 
            scatter.setState(false); 
            sg = null; 
          } 
        }); 
      } 
    } 
    else { 
      if(sg != null) { 
        sg.dispose(); 
        sg = null; 
      } 
    } 
 
    if(regplot.getState()) { 
      if(rp == null) { 
        rp = new Graphs(data, Graphs.REGPLOT); 
        rp.addWindowListener(new WindowAdapter() { 
          public void windowClosing(WindowEvent we) { 
            regplot.setState(false); 
            rp = null; 
          } 
        }); 
      } 
    } 
    else { 
      if(rp != null) { 
        rp.dispose(); 
        rp = null; 
      } 
    }  
 
    if(datawin.getState()) { 
      if(da == null) { 
        da = new DataWin(data); 
        da.addWindowListener(new WindowAdapter() { 
          public void windowClosing(WindowEvent we) { 
            datawin.setState(false); 
            da = null; 
          } 
        }); 
      } 
    } 
    else { 
      if(da != null) { 
        da.dispose(); 
        da = null; 
      } 
    }  
  } 
 
  // Utworzenie menu. 
  private void createMenu() 
  { 
    MenuBar mbar = new MenuBar(); 
    setMenuBar(mbar); 
 
    Menu file = new Menu("Plik"); 
    MenuItem close = new MenuItem("Zamknij"); 
    file.add(close); 
    mbar.add(file); 
    close.addActionListener(this); 
  } 
 
  // Zamknicie okien. 
  private void shutdown() { 
    if(bg != null) bg.dispose(); 
    if(sg != null) sg.dispose(); 
    if(rp != null) rp.dispose(); 
    if(da != null) da.dispose(); 
    setVisible(false); 
    dispose(); 
  } 
}

