import java.util.*; 
import java.text.*; 
 
// Ta klasa przechowuje dane analizy regresyjnej. 
class RegData { 
  public double a, b; 
  public double cor; 
  public String equation; 
 
  public RegData(double i, double j, double k, String str) { 
    a = i; 
    b = j; 
    cor = k; 
    equation = str; 
  } 
} 
 
// Wyjtek zgaszany przez Mode() 
class NoModeException extends Exception { 
  public String toString() { 
    return "Zbir nie zawiera modalnej."; 
  } 
} 
 
// Oglna klasa statystyk. 
public class Stats { 
  // Zwraca redni podanych wartoci. 
  public static double mean(double[] vals) { 
    double avg = 0.0; 
 
    for(int i=0; i < vals.length; i++) 
      avg += vals[i]; 
 
    avg /= vals.length; 
 
    return avg; 
  } 
 
  // Zwraca median podanych wartoci. 
  public static double median(double[] vals) { 
    double temp[] = new double[vals.length]; 
 
    System.arraycopy(vals, 0, temp, 0, vals.length); 
 
    Arrays.sort(temp); // sortowanie danych 
 
    // Zwrcenie rodkowej wartoci. 
    if((vals.length)%2==0) { 
      // Jeli nieparzysta liczba wartoci, znajd redni
      return (temp[temp.length/2] + 
              temp[(temp.length/2)-1]) /2; 
    } else return 
      temp[temp.length/2]; 
  } 
 
  /* Zwraca modaln (dominant) dla podanych wartoci. 
     Wyjtek NoModeException zgaszany jest wtedy, gdy 
     adna z liczb nie wystpuje czciej od pozostaych. 
     Gdy dwie lub wicej wartoci pojawia si rwnie czsto 
     zwracana jest tylko pierwsza z nich. */ 
  public static double mode(double[] vals) 
      throws NoModeException 
  { 
    double m, modeVal = 0.0; 
    int count, oldcount = 0; 
 
    for(int i=0; i < vals.length; i++) { 
      m = vals[i]; 
      count = 0; 
 
      // Zliczanie wystpowa poszczeglnych wartoci. 
      for(int j=i+1; j < vals.length; j++) 
        if(m == vals[j]) count++; 
 
      /* Jeli ta warto wystepuje czciej ni poprzednie  
         zapamitaj j. */ 
      if(count > oldcount) { 
        modeVal = m; 
        oldcount = count; 
      } 
    } 
 
    if(oldcount == 0) 
      throw new NoModeException(); 
    else 
      return modeVal; 
  } 
 
  // Zwraca odchylenie standardowe zbioru wartoci. 
  public static double stdDev(double[] vals) { 
    double std = 0.0; 
    double avg = mean(vals); 
 
    for(int i=0; i < vals.length; i++) 
      std += (vals[i]-avg) * (vals[i]-avg); 
 
    std /= vals.length; 
    std = Math.sqrt(std); 
 
    return std; 
  } 
 
  /* Obliczanie regresji i wspczynnik korelacji
     dla podanego zbioru wartoci. Wartoci reprezentuj  
     wsprzedn Y. Wsprzdn X jest czas
     (inkrementacja o jeden w kadym kroku). */ 
  public static RegData regress(double[] vals) { 
    double a, b, yAvg, xAvg, temp, temp2, cor; 
    double vals2[] = new double[vals.length]; 
 
    // Utworzenie formatu liczbowego z dwoma cyframi po przecinku. 
    NumberFormat nf = NumberFormat.getInstance(); 
    nf.setMaximumFractionDigits(2); 
 
    // Znalezienie redniej wartoci Y. 
    yAvg = mean(vals); 
 
    // Znalezienie redniej komponentu X. 
    xAvg = 0.0; 
    for(int i=0; i < vals.length; i++) xAvg += i; 
    xAvg /= vals.length; 
 
    // Znalezienie b. 
    temp = temp2 = 0.0; 
    for(int i=0; i < vals.length; i++) { 
      temp += (vals[i]-yAvg) * (i-xAvg); 
      temp2 += (i-xAvg) * (i-xAvg); 
    } 
 
    b = temp/temp2; 
 
    // Znalezienie a. 
    a = yAvg - (b*xAvg); 
 
    // Obliczenie wspczynnikw korelacji. 
    for(int i=0; i < vals.length; i++) vals2[i] = i+1; 
    cor = temp/vals.length; 
    cor /= stdDev(vals) * stdDev(vals2); 
 
    return new RegData(a, b, cor, "Y = " + 
                       nf.format(a) +  " + " + 
                       nf.format(b) + " * X"); 
  } 
}

