// Znajdowanie zgubionych kluczy!
import java.util.*;
import java.io.*;

// Informacje o pokoju.
class RoomInfo {
  String from;
  String to;
  boolean skip;

  RoomInfo(String f, String t) {
    from = f;
    to = t;
    skip = false;
  }
}

class Keys {
  final int MAX = 100;

  // Tablica przechowuje informacje o pokojach.
  RoomInfo room[] = new RoomInfo[MAX]; 

  int numRooms = 0; // liczba pokoi

  Stack btStack = new Stack(); // stos powrotu

  public static void main(String args[])
  {    
    String to, from;
    Keys ob = new Keys();

    ob.setup();  

    from = "front_door";
    to = "keys";

    ob.iskeys(from, to);

    if(ob.btStack.size() != 0)
      ob.route(to);
  }
  
  // Inicjalizacja tablicy pokoi.
  void setup()
  {
    addRoom("front_door", "lr");
    addRoom("lr", "bath");
    addRoom("lr", "hall");
    addRoom("hall", "bd1");
    addRoom("hall", "bd2");
    addRoom("hall", "mb");
    addRoom("lr", "kitchen");
    addRoom("kitchen", "keys");
  }
  
  // Umieszczenie pokoi w bazie danych.
  void addRoom(String from, String to)
  {
    if(numRooms < MAX) {
      room[numRooms] = new RoomInfo(from, to);
      numRooms++;
    }
    else System.out.println("Baza pokoi pusta.\n");
  }

  // Pokazanei drogi i odlegoci cznej.
  void route(String to)
  {
    Stack rev = new Stack();
    RoomInfo r;
    int num = btStack.size();

    // Odwr stos, by pokaza drog.
    for(int i=0; i < num; i++) 
      rev.push(btStack.pop());

    for(int i=0; i < num; i++) {
      r = (RoomInfo) rev.pop();
      System.out.print(r.from + " do ");
    }

    System.out.println(to);
  }

  /* Jeli istnieje cieka od rda do celu,
     zwr true, przeciwnie zwr false. */
  boolean match(String from, String to)
  {
    for(int i=numRooms-1; i > -1; i--) {
      if(room[i].from.equals(from) &&
         room[i].to.equals(to) &&
         !room[i].skip)
      {
        room[i].skip = true; // zapobieganie ponownemu uyciu
        return true;
      }
    }

    return false; // nie znaleziono 
  }
  
  // Dla danego z, znajd dowoln ciek.
  RoomInfo find(String from)
  {
    for(int i=0; i < numRooms; i++) {
      if(room[i].from.equals(from) &&
         !room[i].skip)
      {
        RoomInfo r = new RoomInfo(room[i].from,
                           room[i].to);
        room[i].skip = true; // zapobieganie ponownemu uyciu

        return r;
      }
    }
    return null;
  }
  
  // Sprawdzenie drogi midzy z i do. 
  void iskeys(String from, String to)
  {
    int dist;
    RoomInfo r;

    // Sprawdzenie, czy miejsce docelowe.
    if(match(from, to)) {
      btStack.push(new RoomInfo(from, to));
      return;
    }

    // Sprawdzenie innego poczenia.
    r = find(from);
    if(r != null) {
      btStack.push(new RoomInfo(from, to));
      iskeys(r.to, to);
    }
    else if(btStack.size() > 0) {
      // Powrt i sprawdzenie innego poczenia.
      r = (RoomInfo) btStack.pop();
      iskeys(r.from, r.to);
    }
  }
}  
  