// Znajdowanie pocze za pomoca wyszukiwania wszerz.
import java.util.*;
import java.io.*;

// Informacje o locie.
class FlightInfo {
  String from;
  String to;
  int distance;
  boolean skip; // uywane przy wycofywaniu

  FlightInfo(String f, String t, int d) {
    from = f;
    to = t;
    distance = d;
    skip = false;
  }
}

class Breadth {
  final int MAX = 100;

  // Tablica z informacjami o lotach.
  FlightInfo flights[] = new FlightInfo[MAX]; 

  int numFlights = 0; // liczba wpisw w tablicy

  Stack btStack = new Stack(); // stos powrotu

  public static void main(String args[])
  {
    String to, from;
    Breadth ob = new Breadth();
    BufferedReader br = new 
      BufferedReader(new InputStreamReader(System.in)); 
 
    ob.setup();  

    try { 
      System.out.print("Z? ");
      from = br.readLine(); 
      System.out.print("Do? ");
      to = br.readLine(); 

      ob.isflight(from, to);

      if(ob.btStack.size() != 0)
        ob.route(to);
    } catch (IOException exc) { 
      System.out.println("Bd wejcia.");
    }
  }
  
  // Inicjalizacja bazy danych lotw.
  void setup()
  {
    addFlight("New York", "Chicago", 900);
    addFlight("Chicago", "Denver", 1000);
    addFlight("New York", "Toronto", 500);
    addFlight("New York", "Denver", 1800);
    addFlight("Toronto", "Calgary", 1700);
    addFlight("Toronto", "Los Angeles", 2500);
    addFlight("Toronto", "Chicago", 500);
    addFlight("Denver", "Urbana", 1000);
    addFlight("Denver", "Houston", 1000);
    addFlight("Houston", "Los Angeles", 1500);
    addFlight("Denver", "Los Angeles", 1000);
  }
  
  // Umieszczenie lotw w bazie danych.
  void addFlight(String from, String to, int dist)
  {  
    if(numFlights < MAX) {
      flights[numFlights] =
        new FlightInfo(from, to, dist);

      numFlights++;
    }
    else System.out.println("Pena baza lotw.\n");
  }

  // Poka drog i czn odlego.
  void route(String to)
  {
    Stack rev = new Stack();
    int dist = 0;
    FlightInfo f;
    int num = btStack.size();

    // Odwr stos, by pokaza drog.
    for(int i=0; i < num; i++) 
      rev.push(btStack.pop());

    for(int i=0; i < num; i++) {
      f = (FlightInfo) rev.pop();
      System.out.print(f.from + " do ");
      dist += f.distance;
    }

    System.out.println(to);
    System.out.println("Odlego to " + dist);
  }

  /* Jeeli istnieje lot midzy z i do,
     zwr odlego dla tego lotu;
     w przeciwnym razie zwr 0. */
  int match(String from, String to)
  {
    for(int i=numFlights-1; i > -1; i--) {
      if(flights[i].from.equals(from) &&
         flights[i].to.equals(to) &&
         !flights[i].skip)
      {
        flights[i].skip = true; // zapobieganie ponownemu uyciu
        return flights[i].distance;
      }
    }

    return 0; // nie znaleziono 
  }
  
  // Dla danego z, znajd dowolne poczenie.
  FlightInfo find(String from)
  {
    for(int i=0; i < numFlights; i++) {
      if(flights[i].from.equals(from) &&
         !flights[i].skip)
      {
        FlightInfo f = new FlightInfo(flights[i].from,
                             flights[i].to,
                             flights[i].distance);
        flights[i].skip = true; // zapobieganie ponownemu uyciu

        return f;
      }
    }

    return null;
  }
  
  /* Sprawdzenie, czy mona odszuka drog, uywajc
     wyszukiwania wszerz. */
  void isflight(String from, String to)
  {
    int dist, dist2;
    FlightInfo f;

    // W trakcie wyszukiwania potrzebny jest ten stos.
    Stack resetStck = new Stack();

    // Sprawdzenie, czy na miejscu.
    dist = match(from, to);
    if(dist != 0) {
      btStack.push(new FlightInfo(from, to, dist));
      return;
    }

    /* Poniej znajduje si pierwsza modyfikacja.
       Znajduje ona wszystkie loty z danego wza. */
    while((f = find(from)) != null) {
      resetStck.push(f);
      if((dist = match(f.to, to)) != 0) {
        resetStck.push(f.to);
        btStack.push(new FlightInfo(from, f.to, f.distance));
        btStack.push(new FlightInfo(f.to, to, dist));
        return;
      }
    }

    /* Ten kod usuwa wszystkie ustawienia skip ustawione
       w ptli. Stanowi take cz modyfikacji wyszukiwania. */
    int i = resetStck.size();
    for(; i!=0; i--)
      resetSkip((FlightInfo) resetStck.pop());

    // Sprawd inne poczenie.
    f = find(from);
    if(f != null) {
      btStack.push(new FlightInfo(from, to, f.distance));
      isflight(f.to, to);
    }
    else if(btStack.size() > 0) {
      // Powrt i sprawdzenie innego poczenia.
      f = (FlightInfo) btStack.pop();
      isflight(f.from, f.to);
    }
  }

  // Reset pl skip dla danego lotu.
  void resetSkip(FlightInfo f) {
    for(int i=0; i< numFlights; i++)
      if(flights[i].from.equals(f.from) &&
         flights[i].to.equals(f.to))
           flights[i].skip = false;
  }
}
