//Prosty serwlet obliczania rat poyczki. 
import javax.servlet.*;  
import javax.servlet.http.*; 
import java.io.*; 
import java.text.*;  
  
public class RegPayS extends HttpServlet {  
  double principal; // kwota kredytu 
  double intRate;   // oprocentowanie w skali roku 
  double numYears;  // dugo spaty rat w latach 
 
  /* Liczba rat w cigu roku. Mona 
     umoliwi ustalenie tej wartoci przez uytkownika. */ 
  final int payPerYear = 12; 
 
  NumberFormat nf; 
 
  public void doGet(HttpServletRequest request, 
                    HttpServletResponse response) 
    throws ServletException, IOException {  
    String payStr = ""; 
 
    nf = NumberFormat.getInstance(); 
    nf.setMinimumFractionDigits(2); 
    nf.setMaximumFractionDigits(2); 
 
    // Pobranie parametrw. 
    String amountStr = request.getParameter("amount"); 
    String periodStr = request.getParameter("period"); 
    String rateStr = request.getParameter("rate"); 
 
    try {  
      if(amountStr != null && periodStr != null && 
         rateStr != null) { 
        principal = Double.parseDouble(amountStr); 
        numYears = Double.parseDouble(periodStr);      
        intRate = Double.parseDouble(rateStr) / 100; 
 
        payStr = nf.format(compute());   
      } 
      else { // brakuje jednego lub kilku parametrw 
        amountStr = ""; 
        periodStr = ""; 
        rateStr = ""; 
      } 
    } catch (NumberFormatException exc) { 
      // Dla tego wyjtku nie s wymagane adne akcje. 
    } 
 
    // Ustawienie rodzaju zawartoci.  
    response.setContentType("text/html"); 
 
    // Pobranie strumienia wyjciowego. 
    PrintWriter pw = response.getWriter(); 
  
    // Utworzenie odpowiedniego kodu HTML. 
    pw.print("<html><body> <left>" + 
             "<form name=\"Form1\"" + 
             " action=\"http://localhost:8080/" + 
             "examples/servlet/RegPayS\">" + 
             "<B>Wpisz kwot poyczki:</B>" + 
             " <input type=textbox name=\"amount\"" + 
             " size=12 value=\""); 
    pw.print(amountStr + "\">"); 
    pw.print("<BR><B>Wpisz liczb lat:</B>" + 
             " <input type=textbox name=\"period\""+ 
             " size=12 value=\""); 
    pw.println(periodStr + "\">"); 
    pw.print("<BR><B>Wpisz oprocentowanie:</B>" + 
             " <input type=textbox name=\"rate\"" + 
             " size=12 value=\""); 
    pw.print(rateStr + "\">"); 
    pw.print("<BR><B>Miesiczna rata:</B>" + 
             " <input READONLY type=textbox" + 
             " name=\"payment\" size=12 value=\""); 
    pw.print(payStr + "\">"); 
    pw.print("<BR><P><input type=submit value=\"Oblicz\">"); 
    pw.println("</form> </body> </html>");  
  }  
 
  // Obliczanie raty. 
  double compute() { 
    double numer; 
    double denom; 
    double b, e; 
 
    numer = intRate * principal / payPerYear;   
    
    e = -(payPerYear * numYears);   
    b = (intRate / payPerYear) + 1.0;   
   
    denom = 1.0 - Math.pow(b, e);   
 
    return numer / denom;   
  }    
}

