import java.awt.*;
import java.awt.event.*;
import javax.mail.*;
import javax.swing.*;

// Klasa wywietla okno dialogwe tworzenia wiadomoci.
public class MessageDialog extends JDialog
{
  // Identyfikatory wiadomoci.
  public static final int NEW = 0;
  public static final int REPLY = 1;
  public static final int FORWARD = 2;

  // Pola tekstowe nadawcy, adresata i tematu.
  private JTextField fromTextField, toTextField;
  private JTextField subjectTextField;

  // Obszar treci wiadomoci.
  private JTextArea contentTextArea;

  // Informacja o anulowaniu wiadomoci.
  private boolean cancelled;

  // Konstruktor klasy.
  public MessageDialog(Frame parent, int type, Message message)
    throws Exception
  {
    // Wywoanie konstruktora nadrzdnego, wskazanie, i 
	// okno jest typu modal.
    super(parent, true);

    /* Ustawienie tytuu wiadomoci i pobranie wartoci "to", "subject"
       and "content" na podstawie typu wiadomoci. */
    String to = "", subject = "", content = "";
    switch (type) {
      // Odpowied.
      case REPLY:
        setTitle("Odpowied na wiadomo");

        // Pobranie wartoci "to"
        Address[] senders = message.getFrom();
        if (senders != null || senders.length > 0) {
          to = senders[0].toString();
        }
        to = message.getFrom()[0].toString();

        // Pobranie tematu.
        subject = message.getSubject();
        if (subject != null && subject.length() > 0) {
          subject = "Odp: " + subject;
        } else {
          subject = "Odp:";
        }

        // Pobranie zawartoci wiadomoci i dodanie "ODPOWIED NA".
        content = "\n------------------- " +
                  "ODPOWIED NA WIADOMO" +
                  " --------------------\n" +
                  EmailClient.getMessageContent(message);
        break;

      // Posanie wiadomoci dalej.
      case FORWARD:
        setTitle("Posanie wiadomoci dalej");

        // Get message subject.
        subject = message.getSubject();
        if (subject != null && subject.length() > 0) {
          subject = "PD: " + subject;
        } else {
          subject = "PD:";
        }

        // Pobranie zawartoci wiadomoci i dodanie "PRZEKAZANA WIADOMO".
        content = "\n------------------ " +
                  "PRZEKAZANA WIADOMO" +
                  " -------------------\n" +
                  EmailClient.getMessageContent(message);
        break;

      // Nowa wiadomo.
      default:
        setTitle("Nowa wiadomo");
    }

    // Obsuga zamknicia okna.
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        actionCancel();
      }
    });

    // Panel pl.
    JPanel fieldsPanel = new JPanel();
    GridBagConstraints constraints;
    GridBagLayout layout = new GridBagLayout();
    fieldsPanel.setLayout(layout);
    JLabel fromLabel = new JLabel("Od:");
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.EAST;
    constraints.insets = new Insets(5, 5, 0, 0);
    layout.setConstraints(fromLabel, constraints);
    fieldsPanel.add(fromLabel);
    fromTextField = new JTextField();
    constraints = new GridBagConstraints();
    constraints.fill = GridBagConstraints.HORIZONTAL;
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.insets = new Insets(5, 5, 0, 0);
    layout.setConstraints(fromTextField, constraints);
    fieldsPanel.add(fromTextField);
    JLabel toLabel = new JLabel("Do:");
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.EAST;
    constraints.insets = new Insets(5, 5, 0, 0);
    layout.setConstraints(toLabel, constraints);
    fieldsPanel.add(toLabel);
    toTextField = new JTextField(to);
    constraints = new GridBagConstraints();
    constraints.fill = GridBagConstraints.HORIZONTAL;
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.insets = new Insets(5, 5, 0, 0);
    constraints.weightx = 1.0D;
    layout.setConstraints(toTextField, constraints);
    fieldsPanel.add(toTextField);
    JLabel subjectLabel = new JLabel("Temat:");
    constraints = new GridBagConstraints();
    constraints.insets = new Insets(5, 5, 5, 0);
    layout.setConstraints(subjectLabel, constraints);
    fieldsPanel.add(subjectLabel);
    subjectTextField = new JTextField(subject);
    constraints = new GridBagConstraints();
    constraints.fill = GridBagConstraints.HORIZONTAL;
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.insets = new Insets(5, 5, 5, 0);
    layout.setConstraints(subjectTextField, constraints);
    fieldsPanel.add(subjectTextField);

    // Panel zawartoci.
    JScrollPane contentPanel = new JScrollPane();
    contentTextArea = new JTextArea(content, 10, 50);
    contentPanel.setViewportView(contentTextArea);

    // Panel przyciskw.
    JPanel buttonsPanel = new JPanel();
    JButton sendButton = new JButton("Wylij");
    sendButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        actionSend();
      }
    });
    buttonsPanel.add(sendButton);
    JButton cancelButton = new JButton("Anuluj");
    cancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        actionCancel();
      }
    });
    buttonsPanel.add(cancelButton);

    // Dodanie paneli.
    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(fieldsPanel, BorderLayout.NORTH);
    getContentPane().add(contentPanel, BorderLayout.CENTER);
    getContentPane().add(buttonsPanel, BorderLayout.SOUTH);

    // Dostosowanie rozmiaru okna do komponentw.
    pack();

    // Wyrodkowanie okna.
    setLocationRelativeTo(parent);
  }

  // Sprawdzenie pl i zamkniecie okna.
  private void actionSend() {
    if (fromTextField.getText().trim().length() < 1
        || toTextField.getText().trim().length() < 1
        || subjectTextField.getText().trim().length() < 1
        || contentTextArea.getText().trim().length() < 1) {
      JOptionPane.showMessageDialog(this,
        "Nrak jednego lub kilku pl.",
        "Brak pl)", JOptionPane.ERROR_MESSAGE);
      return;
    }

    // Zamknicie okna.
    dispose();
  }

  // Anulowanie tworzenia wiadomoci i zamknicie okna.
  private void actionCancel() {
    cancelled = true;

    // Zamknicie okna.
    dispose();
  }

  // Wywietlenie okna.
  public boolean display() {
    show();

    // Zwrcenie, czy dokonano anulowania, czy te nie.
    return !cancelled;
  }

  // Pobranie pola "Od".
  public String getFrom() {
    return fromTextField.getText();
  }

  // Pobranie pola "Do".
  public String getTo() {
    return toTextField.getText();
  }

  // Pobranie pola "Temat".
  public String getSubject() {
    return subjectTextField.getText();
  }

  // Pobranie pola "zawarto".
  public String getContent() {
    return contentTextArea.getText();
  }
}
