// Znalezienie pozostaej kwoty do spaty. 
import java.awt.*;  
import java.awt.event.*;  
import java.applet.*;  
import java.text.*;  
/*  
  <applet code="RemBal" width=340 height=260>  
  </applet>  
*/  
  
public class RemBal extends Applet  
  implements ActionListener {  
  
  TextField orgPText, paymentText, remBalText, 
            rateText, numPayText; 
  Button doIt;  
  
  double orgPrincipal; // warto pocztkowa poyczki 
  double intRate;      // oprocentowanie 
  double payment;      // wysoko raty 
  double numPayments;  // liczba wpaconych ju rat 
 
  /* Liczba rat w roku. Mona pozwoli 
     wpisywa twarto uytkownikowi. */ 
  final int payPerYear = 12; 
 
  NumberFormat nf; 
 
  public void init() {  
    // Zastosowanie ukadu grid bag. 
    GridBagLayout gbag = new GridBagLayout(); 
    GridBagConstraints gbc = new GridBagConstraints(); 
    setLayout(gbag); 
 
    Label heading = new  
          Label("Znalezienie kwoty do spaty"); 
  
    Label orgPLab = new Label("Kwota poyczki"); 
    Label paymentLab = new Label("Wysoko raty"); 
    Label numPayLab = new Label("Liczba dokonanych wpat"); 
    Label rateLab = new Label("Oprocentowanie"); 
    Label remBalLab = new Label("Pozostaa kwota"); 
 
    orgPText = new TextField(16);  
    paymentText = new TextField(16);  
    remBalText = new TextField(16); 
    rateText = new TextField(16); 
    numPayText = new TextField(16); 
 
    // Pole wyniku tylko do odczytu. 
    remBalText.setEditable(false); 
 
    doIt = new Button("Oblicz");  
 
    // Definiowanie siatki. 
 
    gbc.weighty = 1.0; // wiersze o wadze rwnej 1 
 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbc.anchor = GridBagConstraints.NORTH; 
    gbag.setConstraints(heading, gbc); 
 
    // Dowizanie wikszoci komponentw do prawej. 
    gbc.anchor = GridBagConstraints.EAST; 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(orgPLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(orgPText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(paymentLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(paymentText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(rateLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(rateText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(numPayLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(numPayText, gbc); 
 
    gbc.gridwidth = GridBagConstraints.RELATIVE; 
    gbag.setConstraints(remBalLab, gbc); 
    gbc.gridwidth = GridBagConstraints.REMAINDER; 
    gbag.setConstraints(remBalText, gbc); 
 
    gbc.anchor = GridBagConstraints.CENTER; 
    gbag.setConstraints(doIt, gbc); 
 
    // Dodanie komponentw.  
    add(heading);  
    add(orgPLab);  
    add(orgPText);  
    add(paymentLab);  
    add(paymentText); 
    add(numPayLab);  
    add(numPayText); 
    add(rateLab); 
    add(rateText); 
    add(remBalLab);  
    add(remBalText);  
    add(doIt);  
  
    // Rejestracja w celu otrzymywania zdarze. 
    orgPText.addActionListener(this);  
    numPayText.addActionListener(this);  
    rateText.addActionListener(this);  
    paymentText.addActionListener(this);  
    doIt.addActionListener(this);      
 
    nf = NumberFormat.getInstance(); 
    nf.setMinimumFractionDigits(2); 
    nf.setMaximumFractionDigits(2); 
  }  
  
  /* Uytkownik nacisn Enter w polu tekstowym lub klikn 
     przycisk Oblicz. */ 
  public void actionPerformed(ActionEvent ae) {  
    repaint();  
  }  
  
  public void paint(Graphics g) {  
    double result = 0.0; 
 
    String orgPStr = orgPText.getText();  
    String numPayStr = numPayText.getText();  
    String rateStr = rateText.getText(); 
    String payStr = paymentText.getText(); 
 
    try {  
      if(orgPStr.length() != 0 && 
         numPayStr.length() != 0 && 
         rateStr.length() != 0 && 
         payStr.length() != 0) { 
 
        orgPrincipal = Double.parseDouble(orgPStr); 
        numPayments = Double.parseDouble(numPayStr);      
        intRate = Double.parseDouble(rateStr) / 100; 
        payment = Double.parseDouble(payStr); 
 
        result = compute();   
  
        remBalText.setText(nf.format(result));  
      } 
  
      showStatus(""); // kasowanie poprzedniego komunikatu bdu  
    } catch (NumberFormatException exc) {  
      showStatus("Bdne dane"); 
      remBalText.setText("");  
    }  
  } 
 
  // Obliczenie pozostaej kwoty do spaty. 
  double compute() { 
    double bal = orgPrincipal; 
    double rate = intRate / payPerYear; 
 
    for(int i = 0; i < numPayments; i++) 
      bal -= payment - (bal * rate); 
 
    return bal; 
  }    
}

