import java.awt.*; 
import java.awt.event.*; 
import java.applet.*; 
import java.util.*; 
 
// Oglna klasa rysowania wykresw. 
public class Graphs extends Frame { 
  // Stae rodzajw wykresw. 
  public final static int BAR = 0; 
  public final static int SCATTER = 1; 
  public final static int REGPLOT = 2; 
 
  private int graphStyle; 
 
  /* Okrela ilo miejsca do pozostawienia  
     midzy danymi a krawdzi. */ 
  private final int leftGap = 2; 
  private final int topGap = 2; 
  private final int bottomGap = 2; 
  private int rightGap; // obliczanie tej wartoci  
 
  // Przechowuje warto minimaln i maksymaln danych. 
  private double min, max; 
 
  // Odniesienie si do danych. 
  private double[] data;  
 
  // Kolory wykresu. 
  Color gridColor = new Color(0, 150, 150); 
  Color dataColor = new Color(0, 0, 0); 
  
  // Rne wartoci uywane do skalowania i wywietlania danych. 
  private int hGap;   // odstp midzy punktami danych 
  private int spread; // odstp midzy wartociami min i max 
  private double scale; // wspczynnik skalowania 
  private int baseline; // pionowy wspczynnik podstawy 
 
  // Loklizacja obszaru danych w oknie. 
  private int top, bottom, left, right; 
 
  public Graphs(double[] vals, int style) { 
    // Obsuga zdarze zamknicia okna. 
    addWindowListener(new WindowAdapter() { 
      public void windowClosing(WindowEvent we) { 
        setVisible(false); 
        dispose(); 
      } 
    }); 
 
    // Obsuga zmiany rozmiaru. 
    addComponentListener(new ComponentAdapter() { 
      public void componentResized(ComponentEvent ce) { 
        repaint(); 
      } 
    }); 
 
    graphStyle = style; 
 
    data = vals; 
 
    // Sortowanie danych w celu znalezienia wartoci min i max. 
    double t[] = new double[vals.length]; 
    System.arraycopy(vals, 0, t, 0, vals.length); 
    Arrays.sort(t); 
    min = t[0]; 
    max = t[t.length-1]; 
 
    setSize(new Dimension(200, 120)); 
 
    switch(graphStyle) { 
      case BAR: 
        setTitle("Wykres supkowy"); 
        setLocation(25, 250); 
        break; 
      case SCATTER: 
        setTitle("Wykres punktowy"); 
        setLocation(250, 250); 
        break; 
      case REGPLOT: 
        setTitle("Wykres regresji"); 
        setLocation(475, 250); 
        break; 
    } 
 
    setVisible(true); 
  } 
 
  public void paint(Graphics g) { 
 
    Dimension winSize = getSize(); // rozmiar okna 
    Insets ins = getInsets(); // rozmiar granic 
 
    // Rozmiar aktualnie stosowanej czcionki. 
    FontMetrics fm = g.getFontMetrics(); 
 
    // Obliczenie odpowiedniego odstpu. 
    rightGap = fm.stringWidth("" + data.length); 
 
    // Obliczenie wszystkich przerw dla danego regionu. 
    left = ins.left + leftGap + fm.charWidth('0'); 
    top = ins.top + topGap + fm.getAscent(); 
    bottom = ins.bottom + bottomGap + fm.getAscent(); 
    right = ins.right + rightGap; 
 
    /* Jeli warto minimalna dodatnia, uyj 0 
       jako miejsca pocztkowego. 
       jeli warto maksymalna ujemna, uyj 0. */ 
    if(min > 0) min = 0; 
    if(max < 0) max = 0; 
 
    /* Oblicz odlego midzy minimum i maksimum. */ 
    spread = (int) (max - min); 
 
    // Oblicz wspczynnik skalowania. 
    scale = (double) (winSize.height - bottom - top) / spread; 
 
    // Poznaj pooenie bazy. 
    baseline = (int) (winSize.height - bottom + min * scale);  
 
    // Oblicz odlego midzy danymi. 
    hGap = (winSize.width - left - right) / (data.length-1); 
 
    // Ustaw kolor siatki. 
    g.setColor(gridColor); 
 
    // Narysuj wsprzdne. 
    g.drawLine(left, baseline, 
               left + (data.length-1) * hGap, baseline); 
 
    // Narysuj o Y. 
    if(graphStyle != BAR) 
      g.drawLine(left, winSize.height-bottom, left, top); 
 
    // Wywietl  wartoci min, max i 0. 
    g.drawString("0", ins.left, baseline+fm.getAscent()/2); 
 
    if(max != 0) 
      g.drawString("" + max, ins.left, baseline - 
                   (int) (max*scale) - 4); 
    if(min != 0) 
      g.drawString("" + min, ins.left, baseline - 
                   (int) (min*scale)+fm.getAscent()); 
 
    // Wywietl wartoci. 
    g.drawString("" + data.length, 
                 (data.length-1) * (hGap) + left, 
                 baseline + fm.getAscent()); 
 
    // Ustaw kolor danych. 
    g.setColor(dataColor); 
 
    // Wywietl dane. 
    switch(graphStyle) { 
      case BAR: 
        bargraph(g); 
        break; 
      case SCATTER: 
        scatter(g); 
        break; 
      case REGPLOT: 
        regplot(g); 
        break; 
    } 
  } 
 
  // Wywietlanie wykresu supkowego. 
  private void bargraph(Graphics g) { 
    int v; 
 
    for(int i=0; i < data.length; i++) { 
      v = (int) (data[i] * scale); 
 
      g.drawLine(i*hGap+left, baseline, 
                 i*hGap+left, baseline - v); 
    } 
  } 
 
  // Wywietlanie wykresu punktowego. 
  private void scatter(Graphics g) { 
    int v; 
 
    for(int i=0; i < data.length; i++) { 
      v = (int) (data[i] * scale); 
      g.drawRect(i*hGap+left, baseline - v, 1, 1); 
    } 
  } 
 
  // Wykres punktowy z lini regresji. 
  private void regplot(Graphics g) { 
    int v; 
 
    RegData rd = Stats.regress(data); 
 
    for(int i=0; i < data.length; i++) { 
      v = (int) (data[i] * scale); 
      g.drawRect(i*hGap+left, baseline - v, 1, 1); 
    } 
 
    // Rysowanie linii regresji. 
    g.drawLine(left, baseline - (int) ((rd.a)*scale), 
               hGap*(data.length-1)+left+1, 
               baseline - (int) ((rd.a+(rd.b*(data.length-1)))*scale));     
  } 
}

