import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;

// Mini przegldarka internetowa.
public class MiniBrowser extends JFrame
  implements HyperlinkListener
{
  // Przyciski do poruszania si po licie stron.
  private JButton backButton, forwardButton;

  // Pole tekstowe adresu URL.
  private JTextField locationTextField;

  // Edytor do wywietlani stron.
  private JEditorPane displayEditorPane;

  // Lista odwiedzonych stron przegldarki.
  private ArrayList pageList = new ArrayList();

  // Konstruktor klasy.
  public MiniBrowser()
  {
    // Ustawienie tytuu.
    super("Mini przegldarka");

    // Rozmiar okna.
    setSize(680, 480);

    // Obsuga zamknicia okna.
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        actionExit();
      }
    });

    // Ustawienie menu.
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("Plik");
    fileMenu.setMnemonic(KeyEvent.VK_P);
    JMenuItem fileExitMenuItem = new JMenuItem("Wyjcie",
      KeyEvent.VK_W);
    fileExitMenuItem.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        actionExit();
      }
    });
    fileMenu.add(fileExitMenuItem);
    menuBar.add(fileMenu);
    setJMenuBar(menuBar);

    // Panel przyciskw.
    JPanel buttonPanel = new JPanel();
    backButton = new JButton("< Wstecz");
    backButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        actionBack();
      }
    });
    backButton.setEnabled(false);
    buttonPanel.add(backButton);
    forwardButton = new JButton("Do przodu >");
    forwardButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        actionForward();
      }
    });
    forwardButton.setEnabled(false);
    buttonPanel.add(forwardButton);
    locationTextField = new JTextField(35);
    locationTextField.addKeyListener(new KeyAdapter() {
      public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_ENTER) {
          actionGo();
        }
      }
    });
    buttonPanel.add(locationTextField);
    JButton goButton = new JButton("Id");
    goButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        actionGo();
      }
    });
    buttonPanel.add(goButton);

    // Okno przegldarki.
    displayEditorPane = new JEditorPane();
    displayEditorPane.setContentType("text/html");
    displayEditorPane.setEditable(false);
    displayEditorPane.addHyperlinkListener(this);

    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(buttonPanel, BorderLayout.NORTH);
    getContentPane().add(new JScrollPane(displayEditorPane),
      BorderLayout.CENTER);
  }

  // Wyjcie z programu.
  private void actionExit() {
    System.exit(0);
  }

  // Przejcie do poprzednio przegldanej strony.
  private void actionBack() {
    URL currentUrl = displayEditorPane.getPage();
    int pageIndex = pageList.indexOf(currentUrl.toString());
    try {
      showPage(
        new URL((String) pageList.get(pageIndex - 1)), false);
    }
    catch (Exception e) {}
  }

  // Przejcie w przd ogldanej aktualnie strony.
  private void actionForward() {
    URL currentUrl = displayEditorPane.getPage();
    int pageIndex = pageList.indexOf(currentUrl.toString());
    try {
      showPage(
        new URL((String) pageList.get(pageIndex + 1)), false);
    }
    catch (Exception e) {}
  }

  // Wczytanie i wywietlenie strony wpisanej w polu tekstowym.
  private void actionGo() {
    URL verifiedUrl = verifyUrl(locationTextField.getText());
    if (verifiedUrl != null) {
      showPage(verifiedUrl, true);
    } else {
      showError("Bdny adres URL");
    }
  }

  // Wywietlenie okna dialogowego z komunikatem bdu.
  private void showError(String errorMessage) {
    JOptionPane.showMessageDialog(this, errorMessage,
      "Error", JOptionPane.ERROR_MESSAGE);
  }

  // Weryfikacja formatu URL.
  private URL verifyUrl(String url) {
    // Tylko adresy HTTP.
    if (!url.toLowerCase().startsWith("http://"))
      return null;

    // Weryfikacja URL.
    URL verifiedUrl = null;
    try {
      verifiedUrl = new URL(url);
    } catch (Exception e) {
      return null;
    }

    return verifiedUrl;
  }

  /* Wywietlenie strony i dodanie jej do listy
     odwiedzonych stron. */
  private void showPage(URL pageUrl, boolean addToList)
  {
    // Wywietlenie kursora klepsydry w trakcie wczytywania strony.
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

    try {
      // Pobranie adresu aktualnie wywietlanej strony.
      URL currentUrl = displayEditorPane.getPage();

      // Wczytanie i wywietlenie danej strony.
      displayEditorPane.setPage(pageUrl);

      // Pobranie adresu nowej strony.
      URL newUrl = displayEditorPane.getPage();

      // Dodanie strony do listy.
      if (addToList) {
        int listSize = pageList.size();
        if (listSize > 0) {
          int pageIndex =
            pageList.indexOf(currentUrl.toString());
          if (pageIndex < listSize - 1) {
            for (int i = listSize - 1; i > pageIndex; i--) {
              pageList.remove(i);
            }
          }
        }
        pageList.add(newUrl.toString());
      }

      // Aktualizacja pola tekstowego adresu URL.
      locationTextField.setText(newUrl.toString());

      // Aktualizacja przyciskw w zalenoci od strony.
      updateButtons();
    }
    catch (Exception e)
    {
      // Wywietlenie bdu.
      showError("Bd wczytywania strony");
    }
    finally
    {
      // Zwrcenie domylnego kursora.
      setCursor(Cursor.getDefaultCursor());
    }
  }

  /* Aktualizacja przyciskw na podstawie 
     wywietlanej strony. */
  private void updateButtons() {
    if (pageList.size() < 2) {
      backButton.setEnabled(false);
      forwardButton.setEnabled(false);
    } else {
      URL currentUrl = displayEditorPane.getPage();
      int pageIndex = pageList.indexOf(currentUrl.toString());
      backButton.setEnabled(pageIndex > 0);
      forwardButton.setEnabled(
        pageIndex < (pageList.size() - 1));
    }
  }

  // Obsuga klikni cz.
  public void hyperlinkUpdate(HyperlinkEvent event) {
    HyperlinkEvent.EventType eventType = event.getEventType();
    if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
      if (event instanceof HTMLFrameHyperlinkEvent) {
        HTMLFrameHyperlinkEvent linkEvent =
          (HTMLFrameHyperlinkEvent) event;
        HTMLDocument document =
          (HTMLDocument) displayEditorPane.getDocument();
        document.processHTMLFrameHyperlinkEvent(linkEvent);
      } else {
          showPage(event.getURL(), true);
      }
    }
  }

  // Uruchomienie przegldarki.
  public static void main(String[] args) {
    MiniBrowser browser = new MiniBrowser();
    browser.show();
  }
}
