import java.util.*;
import javax.mail.*;
import javax.swing.*;
import javax.swing.table.*;

// Ta klasa zajmuje si danymi tabeli.
public class MessagesTableModel extends AbstractTableModel
{
  // Nazwy kolumn tabeli.
  private static final String[] columnNames = {"Nadawca",
    "Temat", "Data"};

  // Lista wiadomoci tabeli.
  private ArrayList messageList = new ArrayList();

  // Ustawienie listy wiadomoci.
  public void setMessages(Message[] messages) {
    for (int i = messages.length - 1; i >= 0; i--) {
      messageList.add(messages[i]);
    }

    // Wysanie powiadomienia o zmienia danych.
    fireTableDataChanged();
  }

  // Pobranie komunikatu dla danego wiersza.
  public Message getMessage(int row) {
    return (Message) messageList.get(row);
  }

  // Usunicie komuniaktu z listy.
  public void deleteMessage(int row) {
    messageList.remove(row);

    // Zgoszenie powiadomienia o usuniciu wiersza.
    fireTableRowsDeleted(row, row);
  }

  // Pobranie liczby kolumn.
  public int getColumnCount() {
    return columnNames.length;
  }

  // Pobranie nazw kolumn.
  public String getColumnName(int col) {
     return columnNames[col];
  }

  // Pobranie liczby wierszy.
  public int getRowCount() {
    return messageList.size();
  }

  // Pobranie wartoci danel komrki tabeli.
  public Object getValueAt(int row, int col) {
    try {
      Message message = (Message) messageList.get(row);
      switch (col) {
        case 0: // Nadawca
          Address[] senders = message.getFrom();
          if (senders != null || senders.length > 0) {
            return senders[0].toString();
          } else {
            return "[brak]";
          }
        case 1: // Temat
          String subject = message.getSubject();
          if (subject != null && subject.length() > 0) {
            return subject;
          } else {
            return "[brak]";
          }
        case 2: // Data
          Date date = message.getSentDate();
          if (date != null) {
            return date.toString();
          } else {
            return "[brak]";
          }
      }
    } catch (Exception e) {
      // Cichy bd.
      return "";
    }

    return "";
  }
}
