<html>
<head>
<title>JSP XML Example </title>
</head>

<body>

<%@ page import="java.io.*" %>
<%@ page import="java.util.Hashtable" %>
<%@ page import="org.w3c.dom.*" %>
<%@ page import="org.xml.sax.*" %>
<%@ page import="javax.xml.parsers.SAXParserFactory" %>
<%@ page import="javax.xml.parsers.SAXParser" %>
<%@ page import="SAXHandler" %>

<%

  // Get the path to the file
  File file = new File("purejsp/item.xml");
  FileReader reader = new FileReader(file);
  
  Parser parser;
  // Get an instance of the SAXParserFactory
  SAXParserFactory spf = SAXParserFactory.newInstance();
  // Get a SAXParser instance from the factory
  SAXParser sp = spf.newSAXParser();

  // Create an instance of our HandlerBase
  SAXHandler handler = new SAXHandler();

  // Set the Document handler to call our SAXHandler when
  // SAX event occurs while parsing our XMLResource
  sp.parse(new InputSource(reader), handler);
  // After the resource has been parsed get the resulting table
  Hashtable cfgTable = handler.getTable();

%>
  <table align="center" width="600">
  <caption>XML Item</caption>
<%
  // Print the config settings that we are interested in.
  out.println("<tr><td align=\"left\">ID</td>" +
    "<td align=\"center\">" +
    (String)cfgTable.get(new String("ID")) + "</td></tr>");
  out.println("<tr><td align=\"left\">DESCRIPTION</td>" +
    "<td align=\"center\">" +
    (String)cfgTable.get(new String("DESCRIPTION")) + "</td></tr>");
  out.println("<tr><td align=\"left\">PRICE</td>" +
    "<td align=\"center\">" +
    (String)cfgTable.get(new String("PRICE")) + "</td></tr>");
  System.out.println("<tr><td align=\"left\">QUANTITY</td>" +
    "<td align=\"center\">" +
    (String)cfgTable.get(new String("QUANTITY")) + "</td></tr>");
%>
  </table>
</body>
</html>
