import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.HttpJspPage;
import java.io.*;
import java.util.*;

public abstract class PureJSPBase
  extends HttpServlet
  implements HttpJspPage {

  private ServletConfig config;

  //Initialize global variables
  final public void init(ServletConfig config)
    throws ServletException {

    this.config = config;
    jspInit();
  }

  // provide accessor to the ServletConfig Object
  final public ServletConfig getServletConfig() {

    return config;
  }

  // Provide a simple service method that calls the generated
  // _jspService method.
  final public void service(HttpServletRequest request,
    HttpServletResponse response)
    throws ServletException, IOException {


    _jspService(request, response);
  }

  // Create an abstract method that will be implemented by the JSP processor
  // in the subclass.
  abstract public void _jspService(HttpServletRequest request,
    HttpServletResponse response)
    throws ServletException, IOException;

  // Provide a destroy method
  final public void destroy() {

    jspDestroy();
  }

  // provide some utility methods
  public String getUser(HttpServletRequest request) {

    // get the User name from the request
    return (String)request.getParameter("user");
  }

  public String getCompany(HttpServletRequest request) {

    // get the Company name from the request
    return (String)request.getParameter("company");
  }

  public String getServletInfo() {

    return new String("PureJSPBase");
  }
}
