import java.io.*;

public class SimpleJavaBeanTester {

  public SimpleJavaBeanTester() {

  }

  public void storeBean(SimpleJavaBean value) {

    try {

      // Create the ObjectOutputStream passing it the
      // FileOutputStream object that points to our
      // persistent storage.
      ObjectOutputStream os = new ObjectOutputStream(
        new FileOutputStream("file.dat"));
      // Write the SimpleJavaBean to the ObjectOutputStream
      os.writeObject(value);
      os.flush();
      os.close();
    }
    catch (IOException ioe) {

      System.err.println(ioe.getMessage());
    }
  }

  public SimpleJavaBean getBean() {

    SimpleJavaBean value = null;

    try {

      // Create the ObjectInputStream passing it the
      // FileInputStream object that points to our
      // persistent storage.
      ObjectInputStream is = new ObjectInputStream(
        new FileInputStream("file.dat"));
      // Read the stored object and downcast it back to
      // a SimpleJavaBean
      value = (SimpleJavaBean)is.readObject();
      is.close();
    }
    catch (IOException ioe) {

      System.err.println(ioe.getMessage());
    }
    catch (ClassNotFoundException cnfe) {

      System.err.println(cnfe.getMessage());
    }
    return value;
  }
  
  public void testBean() {

    // Create the Bean
    SimpleJavaBean simpleBean = new SimpleJavaBean();
    // Use accessor to set property
    simpleBean.setSimpleProperty("simple property value");
    // Serialize the Bean to a Persistent Store
    storeBean(simpleBean);

    // Get the Bean from the Persistent Store
    SimpleJavaBean newBean = getBean();

    System.out.println("The newBean's simpleProperty == " +
      newBean.getSimpleProperty());
  }
  
  public static void main(String[] args) {

    SimpleJavaBeanTester simpleJavaBeanTester =
      new SimpleJavaBeanTester();

    simpleJavaBeanTester.testBean();

    try {

      System.out.println("Press enter to continue...");
      System.in.read();
    }
    catch (IOException ioe) {

      System.err.println(ioe.getMessage());
    }
  }
}
