import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

import ShoppingCart;

public class ShopController extends HttpServlet {

  //Initialize global variables
  public void init(ServletConfig config)
    throws ServletException {

    super.init(config);
  }

  //Process the HTTP Post request
  public void doPost(HttpServletRequest request,
    HttpServletResponse response)
    throws ServletException, IOException {

    String command = request.getParameter("command");
    HttpSession session = request.getSession();
    ShoppingCart cart = (ShoppingCart)session.getAttribute("cart");

    // Determine which command to perform
    if ( command.equals("add") ) {

      // Get the item from the request
      String id = request.getParameter("id");
      if ( id != null ) {

        String desc = request.getParameter("desc");
        Float price = new Float(request.getParameter("price"));

        // Add the selected item to the cart
        cart.addItem(id, desc, price.floatValue(), 1);
      }
    }
    // Redirect the response
    // after adding an item to the cart.
    response.sendRedirect("/purejsp/AddToShoppingCartMVC.jsp");
  }

  //Get Servlet information
  public String getServletInfo() {

    return "ShopController Information";
  }
}
