import java.io.*;
import java.rmi.*;
import java.rmi.registry.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DaytimeClientServlet extends HttpServlet {

  DaytimeServer daytime;
  
  // Zwraca referencj do DaytimeServer, lub null, jeeli wystpi problem.
  protected DaytimeServer getDaytimeServer() {

    // Jeeli wykorzysta si funkcj dynamicznego adowania kodu RMI.
    // trzeba ustawi menadera bezpieczestwa taki jak RMISecurityManager
    if (System.getSecurityManager() == null) {
      System.setSecurityManager(new RMISecurityManager());
    }

    try {
      Registry registry =
        LocateRegistry.getRegistry(getRegistryHost(), getRegistryPort());
      return (DaytimeServer)registry.lookup(getRegistryName());
    }
    catch (Exception e) {
      getServletContext().log(e, "Problem z pobraniem referencji do DaytimeServer");
      return null;
    }
  }

  private String getRegistryName() {
    String name = getInitParameter("registryName");
    return (name == null ? "DaytimeServlet" : name);
  }

  private String getRegistryHost() {
    // Zwrcenie nazwy komputera podanej przez "registryHost"
    // lub w przeciwnym wypadku null nakazujcy wybranie localhost
    return getInitParameter("registryHost");
  }

  private int getRegistryPort() {
    try { return Integer.parseInt(getInitParameter("registryPort")); }
    catch (NumberFormatException e) { return Registry.REGISTRY_PORT; }
  }

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
    res.setContentType("text/plain");
    PrintWriter out = res.getWriter();
    
    // pobranie obiektu daytime, jeeli nie zostao to zrobione wczeniej
    if (daytime == null) {
      daytime = getDaytimeServer();
      if (daytime == null) {        
        // Pobranie niemoliwe, wic zgoszenie niedostpnoci.
        throw new UnavailableException(this, "Zlokalizowanie daytime niemoliwe");
      }
    }
    
    // Pobranie i wywietlenie aktualnego czasu na (zazwyczaj zdalnym)
    // komputerze daytime

    out.println(daytime.getDate().toString());
  }
}
