import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.Base64Decoder;

public class CustomAuth extends HttpServlet {
  Hashtable users = new Hashtable();

public void init (ServletConfig config) throws ServletException {
     super.init(config);

    // W nazwach i hasach rozrnialne s due i mae litery!
     users.put("Wallace:cheese",          "allowed");
     users.put("Gromit:sheepnapper",      "allowed");
     users.put("Penguin:evil",            "allowed");
}

public void doGet (HttpServletRequest req, HttpServletResponse res)
           throws ServletException, IOException {
   res.setContentType("text/plain; charset=ISO-8859-2");   
   PrintWriter out = res.getWriter();

  // pobierz nagwek autoryzacji
  String auth = req.getHeader("Authorization");

  // Czy zezwalamy na dostp temu uytkownikowi?
  if (!allowUser(auth)) {
      // nie zezwalamy, informujemy, e nie jest autoryzowany
      res.setHeader("WWW-Authenticate", "BASIC realm=\"users\"");
      res.sendError(res.SC_UNAUTHORIZED);
      // mona zaoferowa mu wpisanie na list zatwierdzonych uytkownikw
  }
else{
  // dopuszczony, wiec pokamy mu tajne rzeczy
  out.println("cile tajne rzeczy");
  }
}

// ta metoda sprawdza informacje uytkownika przesana w nagwku Authorization
// z baza danych uytkownikw zawartych w tablicy haszujcej users
protected boolean allowUser (String auth) throws IOException {
if (auth==null) return false; //brak auth

if(!auth.toUpperCase().startsWith("BASIC"))
return false; //my tylko przeprowadzamy tryb BASIC

// popierz zakodowan nazw uytkownika i haso po "BASIC"
String userpassEncoded = auth.substring(6);

//zdekoduj, uywajc jakikolwiek dekoder Base64 (my uywamy com.oreilly.servlet)
String userpassDecoded = Base64Decoder.decode(userpassEncoded);

// sprawd nasz list uytkownikw czy ten jest "allowed"

if ("allowed".equals(users.get(userpassDecoded)))
   return true;
else
   return false;
  }
}