import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.*;

import org.apache.regexp.*;

public class Links extends HttpServlet {

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
    res.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = res.getWriter();

    // URL do przetworzenia pobierany jest jako dodatkowa cz cieki
    // np.: http://localhost:8080/servlet/Links/www.servlets.com/
    String url = req.getPathInfo();
    if (url == null || url.length() == 0) {
      res.sendError(res.SC_BAD_REQUEST,
                    "Prosz przekaza URL do odczytania jako dodatkow cz cieki");
      return;
    }
    url = url.substring(1);  // odcicie wiodcego '/'
    url = "http://" + url;     // dodanie przedrostka

    String page = null;
    try {
      // danie strony
      HttpMessage msg = new HttpMessage(new URL(url));
      BufferedReader in =
        new BufferedReader(new InputStreamReader(msg.sendGetMessage()));
        
      // Przeksztacenie caej odpowiedzi do String
      StringBuffer buf = new StringBuffer(10240);
      char[] chars = new char[10240];
      int charsRead = 0;
      while ((charsRead = in.read(chars, 0, chars.length)) != -1) {
        buf.append(chars, 0, charsRead);
      }
      page = buf.toString();
    }
    catch (IOException e) {
      res.sendError(res.SC_NOT_FOUND,
                    "Nie mona odczyta z " + url + ":<BR>" +
                    ServletUtils.getStackTraceAsString(e));
      return;
    }

    out.println("<HTML><HEAD><TITLE>Pobieranie czy</TITLE>");

    try {      
      // Konieczne okrelenie <BASE>, eby wzgldne cza dziaay waciwie
      // Jeeli strona ju go posiada, mona go uy
      RE re = new RE("<base[^>]*>", RE.MATCH_CASEINDEPENDENT);
      boolean hasBase = re.match(page);

      if (hasBase) {        
        // Wykorzystanie istniejcego <BASE>
        out.println(re.getParen(0));
      }
      else {        
        // Obliczenie BASE z URL-u, wykorzystanie wszystkiego do ostatniego '/'
        re = new RE("http://.*/", RE.MATCH_CASEINDEPENDENT);
        boolean extractedBase = re.match(url);
        if (extractedBase) {          
          // Sukces, wywietlenie odczytanego BASE
          out.println("<BASE HREF=\"" + re.getParen(0) + "\">");
        }
        else {          
          // Brak wiodcego ukonika, dodanie go
          out.println("<BASE HREF=\"" + url + "/" + "\">");
        }
      }

      out.println("</HEAD><BODY>");

      out.println("cza na <A HREF=\"" + url + "\">" + url + "</A>" +
                  " s nastpujce: <BR>");
      out.println("<UL>");

      String search = "<a\\s+[^<]*</a\\s*>";
      re = new RE(search, RE.MATCH_CASEINDEPENDENT);

      int index = 0;
      while (re.match(page, index)) {
        String match = re.getParen(0);
        index = re.getParenEnd(0);
        out.println("<LI>" + match + "<BR>");
      }

      out.println("</UL>");
      out.println("</BODY></HTML>");
    }
    catch (RESyntaxException e) {
      // Nie powinien wystpi, bo acuchy poszukiwa s sztywne      
      e.printStackTrace(out);
    }
  }
}
