import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class NileBooks extends HttpServlet {

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
    res.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = res.getWriter();

    out.println("<HTML><HEAD><TITLE>Witamy</TITLE></HEAD>");
    out.println("<BODY>");

    // Wywietl pozycj z katalogu 
    RequestDispatcher dispatcher =
      req.getRequestDispatcher("/servlet/NileItem");

    out.println("Prosz nacieszy si tym piknem:");
    req.setAttribute("item", Book.getBook("0596000405"));
    dispatcher.include(req, res);
    
    // Usunicie atrybutu "item" po jego wykorzystaniu
    req.removeAttribute("item");

    out.println("A moe ta:");
    req.setAttribute("item", Book.getBook("0395282659"));
    dispatcher.include(req, res);

    out.println("A poniewa lubimy Ci, te ksiki s o 20% tasze!");

    out.println("</BODY></HTML>");
  }
}

// Prosta klasa Book
class Book {
  String isbn;
  String title;
  String author;

  private static Book JSERVLET =
    new Book("0596000405", "Java Servlet Programming", "Hunter");

  private static Book HOBBIT =
    new Book("0395282659", "The Hobbit", "Tolkien");
  
  // Symulacja wyszukiwania w bazie danych
  public static Book getBook(String isbn) {
    if (JSERVLET.getISBN().equals(isbn)) {
      return JSERVLET;
    }
    else if (HOBBIT.getISBN().equals(isbn)) {
      return HOBBIT;
    }
    else {
      return null;
    }
  }

  private Book(String isbn, String title, String author) {
    this.isbn = isbn;
    this.title = title;
    this.author = author;
  }

  public String getISBN() {
    return isbn;
  }

  public String getTitle() {
    return title;
  }

  public String getAuthor() {
    return author;
  }
}
