package com.oreilly.servlet;

import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public abstract class RemoteHttpServlet extends HttpServlet
                                        implements Remote {
  protected Registry registry;

  public void init(ServletConfig config) throws ServletException {
    super.init(config);
    try {
      // Eksportowanie siebie
      UnicastRemoteObject.exportObject(this);
      // Rejestrowanie siebie
      bind();
    }
    catch (RemoteException e) {
      log("Problem wizania z rejestrem RMI: " + e.getMessage());
    }
  }


  public void destroy() {
    // Wyrejestrowanie siebie
    unbind();
  }
  
  // Zwraca nazw pod ktr obiekt zostanie zarejestrowany
  protected String getRegistryName() {
    // Pierwsz wybieran nazw jest parametr inicjalizacyjny "registryName"
    String name = getInitParameter("registryName");
    if (name != null) return name;

    // Drugim wyborem jest nazwa tej klasy
    return this.getClass().getName();
  }

  // Zwraca port na ktrym nasuchuje (lub powinien nasuchiwa) serwer rejestrujcy
  protected int getRegistryPort() {
    // Pierwszym wybieranym portem jest parametr inicjacji "registryPort"
    try { return Integer.parseInt(getInitParameter("registryPort")); }

    // Drugim wyborem jest domylny port rejestru (1099)
    catch (NumberFormatException e) { return Registry.REGISTRY_PORT; }
  }

  protected void bind() {
    // Prba znalezienia waciwego dziaajcego ju rejestru
    try {
      registry = LocateRegistry.getRegistry(getRegistryPort());
      registry.list();  
    }
    catch (Exception e) {
      // Nie mona byo znale poprawnego rejestru
      registry = null;
    }

    // Jeeli go nie ma, naley go utworzy
    // (Rwnowane uruchomieniu "rmiregistry")
    if (registry == null) {
      try {
        registry = LocateRegistry.createRegistry(getRegistryPort());
      }
      catch (Exception e) { 
        log("Nie mona byo utworzy rejestru RMI na porcie " +
            getRegistryPort() + ": " + e.getMessage());
        return;
      }
    }

    // Jeeli program dotar do tego miejsca, to istnieje prawidowy rejestr
    // Teraz naley zarejestrowa ten egzemplarz serwletu w tym rejestrze
    // Rebind zamienia inne obiekty wykorzystujce t nazw
    try {
      registry.rebind(getRegistryName(), this);
    }
    catch (Exception e) {
      log("Nie udao si zarejestrowanie do rejestru RMI: " + e.getMessage());
      return;
    }
  }

  protected void unbind() {
    try {
      if (registry != null) registry.unbind(getRegistryName());
    }
    catch (Exception e) {
      log("Problem z odrejestrowaniem z rejestru RMI: " + e.getMessage());
    }
  }
}
