import java.sql.*;

public class HtmlSQLResult {
    private String sql;
    private Connection con;
    
public HtmlSQLResult(String sql, Connection con) {
      this.sql = sql;
      this.con = con;
   }

   public String toString() {   // moe by wywoana tylko raz
      StringBuffer out = new StringBuffer();

      // Usu komentarz w poniszej linii aby wywietli instrukcj SQL
      // na pocztku tabeli
      // out.append("Wyniki zapytania instrukcji SQL: " + sql + "<P>\n");

      try {
         Statement stmt = con.createStatement();
         if  (stmt.execute(sql)) {
            ResultSet rs = stmt.getResultSet();
            out.append("<TABLE>\n");
   
            ResultSetMetaData rsmd = rs.getMetaData();
   
           int numcols = rsmd.getColumnCount();
   
            // Tytu tabeli z etykietami kolumn zestawu wynikw
              out.append("<TR>");
              for (int i = 1; i <= numcols; i++) 
                 out.append("<TH>" + rsmd.getColumnLabel(i));  
               out.append("</TR>\n");
         
            while (rs.next()) {
               out.append("<TR>");  // rozpocznij nowy wiersz
                for (int i = 1; i <= numcols; i++) {
                   out.append("<TD>"); // rozpocznij nowy element danych
                   Object obj = rs.getObject(i);
                   if (obj != null)
                       out.append(obj.toString());
                   else
                      out.append("&nbsp;");
                 }
                out.append("</TR>\n"); 
                }

                // Koniec tabeli
                out.append("</TABLE>\n");
            }
               else {
                  //Tu powinna wystpi liczba
                   out.append("<B>Uaktualniono rekordw:</B> " + stmt.getUpdateCount());
             }
            }
       catch (SQLException e) {
            out.append("</TABLE><H1>ERROR:</H1> " + e.getMessage());
         }

         return out.toString();
      }
   }
