import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ShoppingCartViewerRewrite extends HttpServlet {

   public void doGet(HttpServletRequest req, HttpServletResponse res)
                      throws ServletException, IOException {
      res.setContentType ("text/html; charset=ISO-8859-2");
      PrintWriter out = res.getWriter();

      out.println("<HEAD><TITLE>Pozycje w koszyku zakupw</TITLE></HEAD>"); 
      out.println("<BODY>");

      // Pobierz biecy ID sesji lub, w razie koniecznoci, wygeneruj
      String sessionid = req.getPathInfo();
      if (sessionid == null) {
        sessionid = generateSessionId();
      }

      // Artykuy z koszyka zwizane s z ID sesji
      String[] items = getItemsFromCart(sessionid);

      // Drukuj biece artykuy w koszyku.
      out.println(
        "Aktualnie masz w swoim koszyku nastpujce artykuy:<BR>");
      if (items == null) {
        out.println("<B>Koszyk pusty</B>") ;
      }
      else {
        out.println("<UL>") ;
       for (int i = 0; i < items.length; i++) {
          out.println("<LI>" + items[i]) ;
       }
         out.println("</UL>") ;
     }

// Spytaj uytkownika czy chce jeszcze doda jakie artykuy,
// czy te zakoczy. Docz ID sesji do URL-u akcji.
out.println("<FORM ACTION=\"/servlet/ShoppingCart/" + sessionid+
"\" METHOD=POST>") ;
out.println("Jeli chcesz<BR>");
out.println("<INPUT TYPE=SUBMIT VALUE=\"Doda wicej artykuw\">");
out.println("<INPUT TYPE=SUBMIT VALUE=\"Zakoczy\">");
out.println("</FORM>") ;

// zaproponuj stron pomocy. Docz ID sesji do URL-u.
out.println(
   "W celu uzyskania pomocy kliknij <A HREF=\"/servlet/Help/" + sessionid+
     "?topic=ShoppingCartViewerRewrite\">tutaj</A>");
   out.println("</BODY></HTML>") ;
}

private static String generateSessionId() {
   String uid = new java.rmi.server.UID().toString(); // gwarantowana niepowtarzalno
   return java.net.URLEncoder.encode(uid); // zakoduj wszystkie znaki specjalne
}

private static String[] getItemsFromCart(String sessionid) {
   // Nie zaimplementowane   
   }
}
