import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ShoppingCartViewerCookie extends HttpServlet {

   public void doGet(HttpServletRequest req, HttpServletResponse res)
                     throws ServletException, IOException {
      res.setContentType ("text/html; charset=ISO-8859-2");
      PrintWriter out = res.getWriter() ;
      // Pobierz aktualny ID sesji poprzez przeszukanie otrzymanych cookies.
      String sessionid = null;
      Cookie[] cookies = req.getCookies();
     if (cookies != null) {
        for (int i = 0; i < cookies.length; i++) {
           if (cookies[i].getName().equals("sessionid")) {
              sessionid = cookies[i].getValue();
              break;
    }
   }
  }

   // Jeeli ID sesji nie zosta przesany, wygeneruj go.
   // Nastpnie przelij go do klienta razem z odpowiedzi.
   if (sessionid == null) {
      sessionid = generateSessionId();
      Cookie c = new Cookie("sessionid", sessionid);
      res.addCookie(c);
  }

   out.println("<HEAD><TITLE>Pozycje w koszyku zakupw</TITLE></HEAD>");
   out.println("<BODY>");

   // Artykuy z koszyka s zwizane z ID sesji
   String[] items = getItemsFromCart(sessionid);

   // Drukuj aktualne artykuy z koszyka.
   out.println("Aktualnie masz w koszyku nastpujce artykuy:<BR>");
   if (items == null) {
     out.println("<B>Koszyk pusty</B>") ;
  }
else {
   out.println("<UL>") ;
   for (int i = 0; i < items.length; i++) {
     out.println("<LI>" + items[i]) ;
   }
   out.println("</UL>") ;
}

// Spytaj czy chc doda jeszcze jakie artykuy 
// czy te zakoczy zakupy.
out.println("<FORM ACTION=\"/servlet/ShoppingCart\" METHOD=POST>");
out.println("Jeli chcesz:<BR>");
out.println("<INPUT TYPE=SUBMIT VALUE=\"Doda wicej artykuw\">");
out.println("<INPUT TYPE=SUBMIT VALUE=\"Zakoczy\">");
out.println("</FORM>");

// Zaproponuj stron pomocy.
out.println("W celu uzyskania pomocy, kliknij <A HREF=\"/servlet/Help" +
            "?topic=ShoppingCartViewerCookie\">tutaj</A>") ;

out.println("</BODY></HTML>");
}

private static String generateSessionId() {
   // gwarantowana niepowtarzalnio
   String uid = new java.rmi.server.UID().toString();
   // zakoduj wszystkie znaki specjalne
   return java.net.URLEncoder.encode(uid);                   
}
   private static String[] getItemsFromCart (String sessionid) {
     // Nie zaimplementowano
   }
}
