import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class SessionSnoop extends HttpServlet {

public void doGet(HttpServletRequest req, HttpServletResponse res)
                    throws ServletException, IOException {
   res.setContentType("text/html; charset=ISO-8859-2");
   PrintWriter out = res.getWriter() ;

   // Pobierz aktualny obiekt sesji, w razie koniecznoci utwrz go
   HttpSession session = req.getSession();

   // Zwiksz o jeden liczb wej na t stron. Warto jest zapisana 
   // w sesji klienta pod nazw "snoop.count".
   Integer count = (Integer)session.getAttribute("snoop.count");
   if (count == null)
      count = new Integer(1);
   else
      count = new Integer(count.intValue() + 1) ;
   session.setAttribute("snoop.count", count) ;

   out.println("<HTML><HEAD><TITLE>SessionSnoop</TITLE></HEAD>");
   out.println("<BODY><H1>Podsuchiwanie sesji</H1>");

   // Wywietl ilo wej na t stron
   out.println("Odwiedzies t stron  " + count +
      ((count.intValue() == 1) ? " raz." : " razy."));

   out.println("<P>") ;

   out.println("<H3>Oto twoje zachowane dane sesji:</H3>");
   Enumeration enum = session.getAttributeNames();
   while (enum.hasMoreElements()) {
      String name = (String) enum.nextElement();
      out.println(name + ": " + session.getAttribute (name) + "<BR>");
    }

   out.println("<H3>Oto kilka waniejszych stanw twojej sesji:</H3>");
   out.println("ID sesji: " + session.getId() +
             " <I>(trzymaj w tajemnicy)</I><BR>");
   out.println("Nowa sesja: " + session.isNew() + "<BR>");
   out.println("Czas wanoci: " +    
                 session.getMaxInactiveInterval());
   out.println("<I>(" + session.getMaxInactiveInterval() / 60 +
             " minut) </I><BR>") ;
   out.println("Czas utworzenia: " + session. getCreationTime() );
   out. println("<I>(" + new Date (session.getCreationTime ()) +   
             ")</I>><BR>") ;
   out.println("Czas ostatniego poczenia: " +  
            session.getLastAccessedTime());
   out.println("<I>(" + new Date(session.getLastAccessedTime()) +
                  ")</I><BR>") ;

   out.println("ID sesji zlecenia z cookie: " +
             req.isRequestedSessionIdFromCookie () + "<BR>") ;
   out.println("ID sesji zlecenia z URL: " +   
             req. isRequestedSessionIdFromURL () + "<BR>") ;
   out.println("ID sesji zlecenia jest wane: " +
             req.isRequestedSessionIdValid() + "<BR>");

   out.println("<H3>Test przepisywania URL-u</H3>");
   out.println("Kliknij <A HREF=\"" +
             res.encodeURL (req.getRequestURI()) + "\">tutaj</A>") ;
  out.println(
    "aby sprawdzi czy ledzenie sesji dziaa poprzez przepisywanie ");
   out.println("URL-u, nawet wtedy gdy cookies nie s obsugiwane.");

   out.println("</BODY></HTML>") ;
   }
}
