import java.awt.*;
import java.io.*;
import java.net.*;
import javax.servlet.*;
import javax.servlet.http.* ;

import com.oreilly.servlet.ServletUtils;

import Acme.JPM.Encoders.GifEncoder;

public class GraphicalCounter extends HttpServlet {

   public static final String DIR = "/images/odometer";
   public static final String COUNT = "314159";

   public void doGet(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {

     ServletOutputStream out = res.getOutputStream ();

   Frame frame = null;
   Graphics g = null;

try {
   // Pobierz licznik do wywietlenia, musi by jedyn 
   // wartoci w acuchu zapytania. Lub uyj domylnej
   String count = (String)req.getQueryString();
   if (count == null) count = COUNT;
   int countlen = count.length() ;
  Image images[] = new Image[countlen];

for (int i = 0; i < countlen; i++) {
   URL imageSrc =
      getServletContext().getResource(DIR + "/" + count. charAt(i) +  
          ".GIF");
  if (imageSrc == null) {
     imageSrc = new URL ("file:"); // typ zasobu, bdy obsu pniej
   }
   images[i] = Toolkit.getDefaultToolkit().getImage(imageSrc) ;
}

  // Utwrz niewywietlan ramk
  frame = new Frame() ;
  frame.addNotify () ;

// aduj rysunki
MediaTracker mt = new MediaTracker(frame) ;
for (int i = 0; i < countlen; i++) {
   mt.addImage(images[i], i) ;
}

try {
   mt .waitForAll() ;
}
catch (InterruptedException e) {
   res. sendError (res. SC_INTERNAL_SERVER_ERROR,
        "Przerwanie podczas adowania obrazka: " +
        e.getMessage()) ;
  return;
}

// Sprawd czy nie pojawiaj si problemy podczas adowania obrazkw
if (mt.isErrorAny()) {
   //Mielimy problem z ustalenie ktry obrazek(i)
   StringBuffer problemChars = new StringBuffer() ;
   for (int i = 0; i < countlen; i++) {
      if (mt.isErrorID(i)) {
         problemChars.append(count.charAt(i)) ;
   }
}
res.sendError(res.SC_INTERNAL_SERVER_ERROR,
       "Nie mona byo zaadowa obrazka dla tych znakw: " +
       problemChars.toString ()) ;
return;
}

// Pobierz czny rozmiar obrazkw
int width = 0;
int height = 0;
for (int i = 0; i < countlen; i++) {
   width += images[i].getWidth(frame) ;
   height = Math.max(height, images[i].getHeight(frame));
}

// Pobierz obszar grafiki w celu dopasowania, uywajc Frame
Image image = frame.createImage(width, height);

g = image.getGraphics() ;

// Rysuj obrazki
int xindex = 0;
for (int i = 0; i < countlen; i++) {
   g.drawImage(images[i], xindex, 0, frame) ;
   xindex += images [i].getWidth (frame);
}

// Zakoduj i zwr kompozycj
res.setContentType("image/gif") ;
GifEncoder encoder = new GifEncoder(image, out);
encoder.encode() ;
}
finally {
// Zwolnij zasoby
if (g != null) g.dispose();
if (frame != null) frame.removeNotify();
}
}
}
