package com.oreilly.servlet ;

import java.io.* ;
import java.util.*;
import javax.servlet.* ;
import javax.servlet.http.*;

import com.oreilly.servlet.multipart.MultipartParser ;
import com.oreilly.servlet.multipart.Part;
import com.oreilly.servlet.multipart.FilePart ;
import com.oreilly.servlet.multipart.ParamPart ;

// Klasa narzdziowa do obsugi <code>multipart/form-data</code>
public class MultipartRequest {

   private static final int DEFAULT_MAX_POST_SIZE = 1024 * 1024; //1 MB

   private Hashtable parameters = new Hashtable();  // nazwa - Vector wartoci
   private Hashtable files = new Hashtable();            // nazwa - przyjte pliki

   public MultipartRequest (HttpServletRequest request,
      String saveDirectory) throws IOException {
         this(request, saveDirectory, DEFAULT_MAX_POST_SIZE) ;
   }

   public MultipartRequest (HttpServletRequest request,
                            String saveDirectory,
                            int maxPostSize) throws IOException {
   // Wartoci kontroli poprawnoci
   if (request == null)
      throw new IllegalArgumentException (
	"zlecenie nie moe mie wartoci rwnej null");
   if (saveDirectory == null)
      throw new IllegalArgumentException (
	"saveDirectory nie moe mie wartoci rwnej zero");
   if (maxPostSize <= 0) {
      throw new IllegalArgumentException (
	"maxPostSize musi by dodatnie");
   }  
   // Zapisz katalog
   File dir = new File(saveDirectory) ;

   // Sprawd czy saveDirectory jest rzeczywicie katalogiem
   if (!dir.isDirectory())
      throw new IllegalArgumentException("Nie jest katalogiem: "+saveDirectory);

   // Sprawd czy w  saveDirectory mona zapisywa
   if (!dir.canWrite())
      throw new IllegalArgumentException("Nie mona zapisywa: " + saveDirectory);

   // Analizuj nadchodzce, wieloczciowe, zapisywane pliki w podanym 
   // katalogu oraz aduj do bazy meta obiekty, ktre opisuj co znalelimy
   MultipartParser parser = new MultipartParser (request,  maxPostSize);
   Part part;
   while ((part = parser.readNextPart()) != null) {
      String name = part. getName() ;
      if (part.isParam()) {
         // To jest parametr part, dodaj go do wektora wartoci
         ParamPart paramPart = (ParamPart) part;
         String value = paramPart.getStringValue() ;
         Vector existingValues = (Vector) parameters.get(name);
         if (existingValues == null) {
            existingValues = new Vector();
            parameters. put (name, existingValues) ;
   }
   existingValues. addElement(value) ;
}
else if (part.isFile()) {
   // To jest cz pliku
   FilePart filePart = (FilePart) part;
   String fileName = filePart.getFileName();
   if (fileName != null) {
      // Cz aktualnie zawartego pliku
      filePart.writeTo(dir) ;
      files.put(name, new UploadedFile(
            dir.toString(), fileName, filePart.getContentType())) ;
}
else {
   // Pole nie zawierao pliku
   files.put(name, new UploadedFile(null, null, null));
     }
    }
   }
}
 
// Konstruktor ze star sygnatur, utrzymywany dla kompatybilnoci wstecznej.
public MultipartRequest(ServletRequest request, 
                                   String saveDirectory) throws IOException {
   this ((HttpServletRequest) request, saveDirectory);
}

// Konstruktor ze star sygnatur, utrzymywany dla kompatybilnoci wstecznej.
public MultipartRequest (ServletRequest request,
                         String saveDirectory,
                         int maxPostSize) throws IOException {
   this((HttpServletRequest)request, saveDirectory, maxPostSize);
}

public Enumeration getParameterNames() {
   return parameters.keys() ;
}

public Enumeration getFileNames() {
   return files.keys() ;
}

public String getParameter(String name) {
   try {
      Vector values = (Vector) parameters. get (name);
      if (values == null || values.size() == 0) {
         return null;
      }
      String value = (String)values.elementAt(values.size() - 1) ;
      return value;
   }

   catch (Exception e) {
      return null;
   }
}

public String[] getParameterValues(String name) {
   try {
      Vector values = (Vector) parameters.get(name);
      if (values == null || values.size() == 0) {
         return null;
      }
      String[] valuesArray = new String [values.size ()];
      values.copyInto(valuesArray) ;
      return valuesArray;
   }
   catch (Exception e) {
      return null;
   }
}

public String getFilesystemName (String name) {
   try {
      UploadedFile file = (UploadedFile)files.get(name);
      return file.getFilesystemName() ;  // moe by null
   }
   catch (Exception e) {
      return null;
   }
}
public String getContentType(String name) {
   try {
      UploadedFile file = (UploadedFile)files.get(name);
      return file. getContentType(); // moe by null
   }
   catch (Exception e) {
      return null;
   }
}

public File getFile(String name) {
   try {
      UploadedFile file = (UploadedFile)files.get(name);
      return file.getFile();  // moe by null
   }
   catch (Exception e) {
      return null;
   }
  }
}

// Klasa do przechowywania informacji o przyjtym pliku.
class UploadedFile {

   private String dir;
   private String filename;
   private String type;
   
   UploadedFile(String dir, String filename, String type) {
      this.dir = dir;
      this.filename = filename;
      this.type = type;
   }

   public String getContentType() {
      return type;
}

   public String getFilesystemName () {
      return filename;
}

  public File getFile() {
   if (dir == null || filename == null) {
      return null;
    }
else {
   return new File(dir + File.separator + filename);
  }
   }
  }