import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class InitDestroyCounter extends HttpServlet   {

  int count;

  public void init() throws ServletException {
  //Sprbuj odczyta warto pocztkow  dla count z zapisanego i trwaego stanu

  FileReader fileReader = null;
  BufferedReader bufferedReader = null;

 try {
  fileReader = new FileReader("InitDestroyCounter.initial");
   bufferedReader = new BufferedReader(fileReader);
   String initial = bufferedReader.readLine();
   count  = Integer.parseInt(initial);
   return;
  }
  catch (FileNotFoundException ignored) { }  // brak stanu zapisanego
  catch (IOException ignored) { }                 // problem podczas czytania
  catch (NumberFormatException ignored) { }  //niepoprawnie zapisany stan
  finally {
   // Nie zapomnij zamkn pliku
   try  {
   if (bufferedReader != null) {
   bufferedReader.close();
  }
}
  catch (IOException ignored) {}
}

// W razie niepowodzenia,
// sprawd parametr inicjalizujcy
String initial = getInitParameter("initial");
try {
  count = Integer.parseInt(initial);
  return;
 }
 catch (NumberFormatException ignored) {} //null lub liczba nie cakowita

 // Domylne dla pocztkowego stanu licznika "0"
 count = 0;
}


public void doGet (HttpServletRequest  req, HttpServletResponse res)
                                throws ServletException, IOException {

     res.setContentType ("text/plain; charset=ISO-8859-2");

PrintWriter  out  = res.getWriter();
count++;
out.println  ("Z serwletem poczono si ju " + 
               count + " razy.");
}

public void destroy() {
  super.destroy(); //cakowicie opcjonalne
  saveState();
}

public void saveState() {
  // Sprbuj zapisa biec warto
  FileWriter fileWriter = null;
  PrintWriter printWriter = null;
  try {
    fileWriter = new FileWriter("InitDestroyCounter.initial");
    printWriter = new PrintWriter(fileWriter);
    printWriter.println(count);
    return;
}

catch (IOException e) { // problem podczas pisania
  // Zgo wyjtek. Patrz rozdzia 5.
}

finally {
   // Nie zapomnij zamkn plik
   if (printWriter != null) {
    printWriter.close();
    }
   }
  }
 }
